/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/autoscaling/v1"
	autoscalingv1 "k8s.io/client-go/applyconfigurations/autoscaling/v1"
	gentype "k8s.io/client-go/gentype"
	typedautoscalingv1 "k8s.io/client-go/kubernetes/typed/autoscaling/v1"
)

// fakeHorizontalPodAutoscalers implements HorizontalPodAutoscalerInterface
type fakeHorizontalPodAutoscalers struct {
	*gentype.FakeClientWithListAndApply[*v1.HorizontalPodAutoscaler, *v1.HorizontalPodAutoscalerList, *autoscalingv1.HorizontalPodAutoscalerApplyConfiguration]
	Fake *FakeAutoscalingV1
}

func newFakeHorizontalPodAutoscalers(fake *FakeAutoscalingV1, namespace string) typedautoscalingv1.HorizontalPodAutoscalerInterface {
	return &fakeHorizontalPodAutoscalers{
		gentype.NewFakeClientWithListAndApply[*v1.HorizontalPodAutoscaler, *v1.HorizontalPodAutoscalerList, *autoscalingv1.HorizontalPodAutoscalerApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("horizontalpodautoscalers"),
			v1.SchemeGroupVersion.WithKind("HorizontalPodAutoscaler"),
			func() *v1.HorizontalPodAutoscaler { return &v1.HorizontalPodAutoscaler{} },
			func() *v1.HorizontalPodAutoscalerList { return &v1.HorizontalPodAutoscalerList{} },
			func(dst, src *v1.HorizontalPodAutoscalerList) { dst.ListMeta = src.ListMeta },
			func(list *v1.HorizontalPodAutoscalerList) []*v1.HorizontalPodAutoscaler {
				return gentype.ToPointerSlice(list.Items)
			},
			func(list *v1.HorizontalPodAutoscalerList, items []*v1.HorizontalPodAutoscaler) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
