#!/bin/sh

# Print architecture in a format that Docker / Silicon Valley understands.
# Don’t we love how uname(1), Docker, and nVidia all disagree on arch names?

case $(uname -m) in
    x86_64)
        echo amd64
        ;;
    aarch64)
        echo arm64
        ;;
    *)
        echo "error: unknown architecture: $(uname -m)" 1>&2
        exit 1
        ;;
esac
