<?php
/*
    FibuSQL 0.4.1  -  (c) 2003 Martin Pitt <martin@piware.de>

    This software is protected by the GNU General Public License (see
    file COPYING).
*/

include_once 'backend/ledger.inc';

$account = get_http_int( 'account', 1 );
if( !$account )
    $account = 0;
$showcumul = ($HTTP_GET_VARS['cumulative'] == 'yes') ? TRUE : FALSE;

if( $HTTP_GET_VARS['generate'] ) {
    $fname = $account ? "ledger-$account.xml" : 'ledger.xml';
    if( $HTTP_GET_VARS['xsl'] == 'user' )
	$xslurl = $HTTP_GET_VARS['xslurl'];
    $maxlvl = ($HTTP_GET_VARS['recursive'] == 'yes') ? -1 : 1;
    header( 'Content-type: text/xml' );
    header( 'Content-Disposition: attachment; filename='.$fname );
    check_res_delay( gen_ledger_xml( $account, $maxlvl, $xslurl ) );
    exit; 
}

include_once 'pagehead-html.inc';
include_once get_lang_inc( '-ledger' );

$res_accounts = $db->query( 'select account, name from accounts where account <> 0 order by account' );
check_res( $res_accounts, $LANG_err_readacc );

$accdata = $db->getRow( 'select parent, type from accounts where account='.$account );
check_res( $accdata, $LANG_err_readacc );

if( $account > 0 )
    $parentname = htmlq( $db->getOne( 'select name from accounts where account='.$accdata[0] ) );


switch( $HTTP_GET_VARS['order'] ) {
    case 'desc':    $sort = LEDGER_SORT_DESC; break;
    case 'time':    $sort = LEDGER_SORT_TIME; break;
    case 'rtime':   $sort = LEDGER_SORT_RTIME; break;
    case 'receipt': $sort = LEDGER_SORT_RECEIPT; break;
    default:	    $sort = null;
}
?>

<h2><?php echo $LANG_menu_ledger ?></h2>

<form method="get" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF'] ?>">
  <p><select name="account">
  <?php
  echo '<option value="0"> 0 - ' . $LANG_balsheet . "</option>\n";
  while( $row = $res_accounts->fetchRow() ) {
      echo '<option value="' . $row[0] . '"';
      if( $HTTP_GET_VARS['account'] == $row[0] )
          echo ' selected="selected"';
      echo '>' . $row[0] . " - " . htmlq( $row[1] ) . "</option>\n";
  }
  ?>
  </select>
  <input type="checkbox" name="cumulative" value="yes" <?php 
      if( $showcumul ) echo 'checked="checked"'; 
      echo ' />', $LANG_withcumulativebal 
  ?>
  <input type="submit" name="show" value=" <?php echo $LANG_show ?> " />
  <?php if( $account ) { ?>
  <input type="submit" name="stats" value=" <?php echo $LANG_menu_stats ?> " />
  <?php } ?>
  <input type="submit" name="xml" value=" <?php echo $LANG_ledgerxml ?> " />

  <?php
    if( $sort )
	echo '<input type="hidden" name="order" value="',
	    $HTTP_GET_VARS['order'], "\" />\n";
  ?>
  </p>
</form>  

<?php
# determine what to display
if( $HTTP_GET_VARS['stats'] ) {
    include 'ledger-stats.inc';
}
else if( $HTTP_GET_VARS['xml'] ) {
    include 'ledger-xml.inc';
}
else {
    include 'ledger-account.inc';
}
?>

</body>
</html>
