#!/usr/bin/env python

import sys
import unittest
from threading import Thread

from Fnorb.orb import BOA, CORBA
import datatransfer, datatransfer_skel

from orbrunner import ORBRunner
from serverrunner import ServerRunner

#
# The test case for "wstring" type transmission.
#
class WStringTest(unittest.TestCase):

    def __init__(self, orb_runner):
        unittest.TestCase.__init__(self)
        self.orb_runner = orb_runner;

    #
    # Create the implementation of the "wstring" type test interface and
    # register it with the ORB.
    #
    def setUp(self):
        orb = self.orb_runner.getORB()
        stringified_ior = open('wstring.ref', 'r').read()
        self.obj = orb.string_to_object(stringified_ior)

    def tearDown(self):
        # Do nothing for the time being
        pass

    #
    # Perform the "wstring" type interface tests.
    #
    def runTest(self):
        wstring = u'fnorb'

	result = self.obj.wStringIn(wstring)
    
        self.assertEqual(result, wstring)

        self.assertEqual(self.obj.wStringOut(wstring), wstring)

        wstring_in = u'corba'
        (wstring_ret, wstring_out) = self.obj.wStringInOut(wstring, wstring_in)

        self.assertEqual(wstring_ret, wstring_in)
        self.assertEqual(wstring_out, wstring)

#
# Create a testsuite for testing "wstring" type transmission. This is
# meant to be used by other modules wanting to incorporate these
# tests.
#
def build_test_suite(orb_runner):
    wstring_test = WStringTest(orb_runner)
    test_suite = unittest.TestSuite([wstring_test])
    return test_suite

#
# Run the tests with an ORB. This is meant to be used when this module
# is executed as a stand-alone program.
#
def run_tests():
    orb_runner = ORBRunner()

    test_suite = build_test_suite(orb_runner)

    test_runner = unittest.TextTestRunner()
    test_runner.run(test_suite)

#
# If this module was loaded as a program, then run the tests.
#
if __name__ == "__main__":
    run_tests()
