/* Copyright (C) 2000-2004 by George Williams */
/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.

 * The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "gdraw.h"
#include "gicons.h"

static uint8 textmake_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 
	0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x3, 0x0, 
	0x3, 0x3, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x3, 
	0x0, 0x3, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x3, 
	0x0, 0x3, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut textmake_clut = { 4, 0, 0,
    0xffffff, 0x0, 0x444444, 0xff0000 };

static struct _GImage textmake_base = {
    it_index,
    0,16,16,16,
    (uint8 *) textmake_data,
    &textmake_clut,
    0
};

static uint8 textc0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 
	0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x4, 
	0x4, 0x4, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x4, 
	0x4, 0x4, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut textc0_clut = { 5, 0, 0,
    0xffffff, 0x0, 0x444444, 0xd0d0ff, 0x0000ff };
    
static struct _GImage textc0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) textc0_data,
    &textc0_clut,
    0
};

static uint8 image0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 
	0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x2, 
    0x2, 0x5, 0x5, 0x6, 0x6, 0x6, 0x6, 0x5, 
	0x5, 0x5, 0x5, 0x5, 0x7, 0x7, 0x5, 0x2, 
    0x2, 0x5, 0x5, 0x5, 0x5, 0x5, 0x6, 0x5, 
	0x5, 0x5, 0x5, 0x5, 0x7, 0x7, 0x5, 0x2, 
    0x2, 0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 
	0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x2, 
    0x2, 0x5, 0x4, 0x4, 0x4, 0x4, 0x5, 0x5, 
	0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x4, 0x2, 
    0x2, 0x4, 0x1, 0x1, 0x1, 0x1, 0x4, 0x5, 
	0x4, 0x4, 0x4, 0x4, 0x5, 0x4, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 
	0x1, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x4, 0x1, 0x1, 0x4, 0x1, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut image0_clut = { 8, 0, 0,
    0xffffff, 0x20a020, 0x0, 0x808080, 0x8000, 0xc0c0ff, 0xffffff, 0xffff00 };

static struct _GImage image0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) image0_data,
    &image0_clut,
    0xffffffff
};

static uint8 video0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 
	0x2, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x0, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 
    0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x0, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 
	0x2, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x7, 
    0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x7, 0x7, 
    0x2, 0x2, 0x2, 0x3, 0x2, 0x3, 0x3, 0x3, 
	0x2, 0x3, 0x2, 0x2, 0x2, 0x7, 0x7, 0x7, 
    0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x2, 0x7, 0x7, 0x7, 
    0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x2, 0x7, 0x7, 0x7, 
    0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x0, 0x0, 0x7, 0x7, 
    0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 0x7, 
    0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage video0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) video0_data,
    &image0_clut,
    0
};

static uint8 core0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage core0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) core0_data,
    &textmake_clut,
    0
};

static uint8 textplain0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 
	0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage textplain0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) textplain0_data,
    &textc0_clut,
    0
};

static uint8 dir0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage dir0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) dir0_data,
    &textc0_clut,
    0
};

static uint8 updir0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x1, 0x1, 0x1, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage updir0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) updir0_data,
    &textc0_clut,
    0
};

static uint8 object0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x1, 0x1, 0x1, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x1, 0x1, 0x1, 0x2, 0x0, 
	0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x1, 0x1, 0x1, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
    0x0, 0x0, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x1, 0x1, 0x1, 0x2, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage object0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) object0_data,
    &textmake_clut,
    0
};

static uint8 texthtml0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x3, 0x3, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x0, 
	0x1, 0x3, 0x3, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x3, 0x3, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0
};

static struct _GImage texthtml0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) texthtml0_data,
    &textc0_clut,
    0
};

static uint8 textxml0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x3, 0x0, 0x3, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 0x1, 
	0x0, 0x3, 0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x3, 0x0, 0x3, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0
};

static struct _GImage textxml0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) textxml0_data,
    &textc0_clut,
    0
};

static uint8 textcss0_data[] = {
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0
};

static struct _GImage textcss0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) textcss0_data,
    &textc0_clut,
    0
};

static uint8 textjava0_data[] = {
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x3, 
    0x3, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x3, 0x2, 0x3, 0x0, 0x0, 0x3, 
    0x3, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x3, 0x2, 0x2, 0x3, 0x3, 0x3, 0x0, 
    0x3, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x3, 0x2, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 
	0x3, 0x2, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x2, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x2, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut textjava0_clut = { 6, 0, 0,
    0xffffff, 0xbbbbbb, 0x777777, 0x0, 0x444444, 0x8080ff };

static struct _GImage textjava0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) textjava0_data,
    &textjava0_clut,
    0
};

static uint8 textbdf0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage textbdf0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) textbdf0_data,
    &textc0_clut,
    0
};

static uint8 textfontps0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage textfontps0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) textfontps0_data,
    &textc0_clut,
    0
};

static uint8 textfontsfd0_data[] = {
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x0, 0x1, 0x1, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0
};

static struct _GImage textfontsfd0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) textfontsfd0_data,
    &textc0_clut,
    0
};

static uint8 textps0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2,
	0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2,
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x4, 0x4, 0x4, 0x0, 0x0, 0x0,
	0x4, 0x4, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x4, 0x0, 0x0, 0x4, 0x0, 0x4,
	0x0, 0x0, 0x4, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x4, 0x0, 0x0, 0x4, 0x0, 0x4,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x4, 0x4, 0x4, 0x0, 0x0, 0x0,
	0x4, 0x4, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x4, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x4,
	0x4, 0x4, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage textps0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) textps0_data,
    &textc0_clut,
    0
};

static uint8 unknown0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x2, 0x2, 
	0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage unknown0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) unknown0_data,
    &textc0_clut,
    0
};

static uint8 audio0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage audio0_base = {
    it_index,
    2081,16,16,16,
    (uint8 *) audio0_data,
    &textc0_clut,
    0
};


static uint8 ttf0_data[] = {
    0x0, 0x1f, 
    0x7b, 0xdf, 
    0xfb, 0xff, 
    0xc0, 0x1, 
    0xdb, 0xfd, 
    0xd0, 0x85, 
    0xc2, 0xb1, 
    0xfa, 0xbf, 
    0xfa, 0xbf, 
    0xfa, 0xbf, 
    0xf0, 0xbf, 
    0xfe, 0xbf, 
    0xfc, 0x9f, 
    0xfd, 0xdf, 
    0xfc, 0x1f, 
    0xff, 0xff, 
};

static GClut ttf0_clut = { 2, 0, 1,
    0x0, 0xb0b0b0 };

static struct _GImage ttf0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) ttf0_data,
    &ttf0_clut,
    1
};

static GClut macttf_clut = { 2, 0, 1,
    0xff, 0xffffff };

static struct _GImage macttf0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) ttf0_data,
    &macttf_clut,
    1
};

static uint8 cid0_data[] = {
    0xff, 0xff, 
    0xfb, 0xff, 
    0x80, 0x3f, 
    0xbf, 0xbf, 
    0xff, 0xff, 
    0xc0, 0x7f, 
    0xfe, 0xff, 
    0xfd, 0xff, 
    0xfb, 0xff, 
    0x80, 0x3f, 
    0xfb, 0xff, 
    0xfb, 0xff, 
    0xfb, 0xff, 
    0xfb, 0xff, 
    0xf7, 0xff, 
    0xff, 0xff, 
};

static struct _GImage cid0_base = {
    it_mono,
    2071,11,16,2,
    (uint8 *) cid0_data,
    &ttf0_clut,
    1
};

static uint8 mac_data[] = {
    0xff, 0xff, 
    0xc0, 0x3, 
    0xdf, 0xfb, 
    0xd0, 0xb, 
    0xd7, 0xeb, 
    0xd5, 0xab, 
    0xd7, 0xeb, 
    0xd5, 0xab, 
    0xd6, 0x6b, 
    0xd7, 0xeb, 
    0xd0, 0xb, 
    0xdf, 0xfb, 
    0xdf, 0xb, 
    0xdf, 0xfb, 
    0xc0, 0x3, 
    0xff, 0xff, 
};

static struct _GImage mac_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) mac_data,
    &ttf0_clut,
    1
};

static uint8 tar0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x1, 0x5, 0x5, 0x5, 0x5, 0x2, 0x2, 0x2, 
	0x4, 0x3, 0x4, 0x3, 0x3, 0x6, 0x4, 0x0, 
    0x1, 0x5, 0x5, 0x5, 0x2, 0x2, 0x2, 0x2, 
	0x4, 0x3, 0x4, 0x3, 0x6, 0x6, 0x4, 0x0, 
    0x1, 0x5, 0x5, 0x2, 0x2, 0x2, 0x2, 0x3, 
	0x3, 0x4, 0x3, 0x6, 0x6, 0x6, 0x4, 0x0, 
    0x1, 0x5, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 
	0x4, 0x3, 0x4, 0x6, 0x6, 0x6, 0x4, 0x0, 
    0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x3, 
	0x4, 0x6, 0x4, 0x6, 0x6, 0x7, 0x4, 0x0, 
    0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x4, 0x6, 0x4, 0x6, 0x7, 0x7, 0x4, 0x0, 
    0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x6, 
	0x6, 0x4, 0x6, 0x7, 0x7, 0x7, 0x4, 0x0, 
    0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x6, 0x6, 
	0x4, 0x6, 0x4, 0x7, 0x7, 0x7, 0x4, 0x0, 
    0x1, 0x3, 0x3, 0x3, 0x3, 0x6, 0x6, 0x6, 
	0x4, 0x7, 0x4, 0x7, 0x7, 0x7, 0x4, 0x0, 
    0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut tar0_clut = { 16, 0, 0,
    0xffffff, 0xff0000, 0xa0a0ff, 0x8080ff, 0x0, 0xc0c0ff, 0x6060ff, 0x4040ff, 
    0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff };

static struct _GImage tar0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) tar0_data,
    &tar0_clut,
    0x0
};

static uint8 compressed0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x0, 0x1, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x2, 0x0, 0x0, 
    0x3, 0x5, 0x6, 0x6, 0x2, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x7, 0x4, 0x2, 0x0, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x0, 0x1, 0x4, 0x1, 0x0, 
    0x3, 0x8, 0x8, 0x8, 0x8, 0x5, 0x5, 0x5, 
	0x6, 0x6, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 
    0x3, 0x8, 0x8, 0x8, 0x5, 0x5, 0x5, 0x6, 
	0x6, 0x6, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 
    0x3, 0x8, 0x8, 0x5, 0x5, 0x5, 0x6, 0x6, 
	0x6, 0x6, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 
    0x3, 0x8, 0x5, 0x5, 0x5, 0x6, 0x6, 0x6, 
	0x6, 0x6, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 
    0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x6, 0x6, 
	0x6, 0x9, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 
    0x3, 0x5, 0x5, 0x6, 0x6, 0x6, 0x6, 0x6, 
	0x9, 0x9, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 
    0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x7, 0x4, 0x2, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x4, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x7, 0x1, 0x4, 0x1, 0x7, 0x1, 0x7, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 
	0x1, 0x7, 0x1, 0x4, 0x1, 0x7, 0x1, 0x0
};

static GClut compressed0_clut = { 16, 0, 0,
    0xffffff, 0x0, 0x3030, 0xff0000, 0xc0c0c0, 0xa0a0ff, 0x8080ff, 0x808080, 
    0xc0c0ff, 0x4040ff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff };

static struct _GImage compressed0_base = {
    it_index,
    0,16,16,16,
    (uint8 *) compressed0_data,
    &compressed0_clut,
    0x0
};

GImage _GIcon_compressed = { 0, &compressed0_base };
GImage _GIcon_tar = { 0, &tar0_base };
GImage _GIcon_ttf = { 0, &ttf0_base };
GImage _GIcon_unknown = { 0, &unknown0_base };
GImage _GIcon_texthtml = { 0, &texthtml0_base };
GImage _GIcon_textxml = { 0, &textxml0_base };
GImage _GIcon_textcss = { 0, &textcss0_base };
GImage _GIcon_textjava = { 0, &textjava0_base };
GImage _GIcon_textfontsfd = { 0, &textfontsfd0_base };
GImage _GIcon_textfontbdf = { 0, &textbdf0_base };
GImage _GIcon_textfontps = { 0, &textfontps0_base };
GImage _GIcon_textps = { 0, &textps0_base };
GImage _GIcon_textplain = { 0, &textplain0_base };
GImage _GIcon_textc = { 0, &textc0_base };
GImage _GIcon_textmake = { 0, &textmake_base };
GImage _GIcon_object = { 0, &object0_base };
GImage _GIcon_updir = { 0, &updir0_base };
GImage _GIcon_dir = { 0, &dir0_base };
GImage _GIcon_core = { 0, &core0_base };
GImage _GIcon_image = { 0, &image0_base };
GImage _GIcon_video = { 0, &video0_base };
GImage _GIcon_audio = { 0, &audio0_base };
GImage _GIcon_cid = { 0, &cid0_base };
GImage _GIcon_mac = { 0, &mac_base };
GImage _GIcon_macttf = { 0, &macttf0_base };
