#! /bin/sh
# Copyright (C) 2019 Red Hat, Inc.
# This file is part of elfutils.
#
# This file is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# elfutils is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

. $srcdir/test-subr.sh

testfiles testfile-riscv64-dis1.o testfile-riscv64-dis1.expect
testrun_compare ${abs_top_builddir}/src/objdump -d testfile-riscv64-dis1.o < testfile-riscv64-dis1.expect

exit $?

# The following code is used to generate the test file.
cat <<EOF | riscv64-linux-gnu-as -c -o testfile-riscv64-dis1.o -
.text
.word 0x80000037
.word 0x800000b7
.word 0x40300137
.word 0x90000017
.word 0x01003317
.word 0x000000ef
.word 0x0000116f
.word 0x000021ef
.word 0x0000426f
.word 0x000082ef
.word 0x0001036f
.word 0x000203ef
.word 0x0004046f
.word 0x000804ef
.word 0x0010056f
.word 0x002005ef
.word 0x0040066f
.word 0x008006ef
.word 0x0100076f
.word 0x020007ef
.word 0x0400086f
.word 0x080008ef
.word 0x1000096f
.word 0x200009ef
.word 0x40000a6f
.word 0x80000aef
.word 0x00000067
.word 0x80008567
.word 0x050109e7
.word 0x00d30863
.word 0x80c41463
.word 0x40d348e3
.word 0x20d35263
.word 0x10d364e3
.word 0x08d37463
.word 0x00000003
.word 0x83050703
.word 0x00001003
.word 0x850c1383
.word 0x04012003
.word 0xa50c2383
.word 0x05013003
.word 0xf50c3383
.word 0x00004003
.word 0x83054703
.word 0x00005003
.word 0x850c5383
.word 0x04016003
.word 0xa50c6383
.word 0x00000023
.word 0x5f430323
.word 0x00001023
.word 0x5f431323
.word 0x00002023
.word 0x5f432323
.word 0x00003023
.word 0x5f433323
.word 0x00000013
.word 0x00000093
.word 0x00300093
.word 0x00310093
.word 0x00002013
.word 0x00002093
.word 0x00302093
.word 0x00312093
.word 0x00003013
.word 0x00003093
.word 0x00303093
.word 0x00313093
.word 0x00004013
.word 0x00004093
.word 0x00304093
.word 0x00314093
.word 0x00006013
.word 0x00006093
.word 0x00306093
.word 0x00316093
.word 0x00007013
.word 0x00007093
.word 0x00307093
.word 0x00317093
.word 0x00311093
.word 0x00315093
.word 0x40315093
.word 0x00000033
.word 0x010000b3
.word 0x40000033
.word 0x410000b3
.word 0x40010033
.word 0x410200b3
.word 0x00001033
.word 0x010010b3
.word 0x00002033
.word 0x010020b3
.word 0x00012033
.word 0x010220b3
.word 0x00003033
.word 0x010030b3
.word 0x00043033
.word 0x010530b3
.word 0x00004033
.word 0x010040b3
.word 0x00005033
.word 0x010050b3
.word 0x40005033
.word 0x410050b3
.word 0x00006033
.word 0x010060b3
.word 0x00007033
.word 0x010070b3
.word 0x0000000f
.word 0x0210000f
.word 0x00000073
.word 0x00100073
.word 0x0000001b
.word 0x0010001b
.word 0x0000101b
.word 0x0010101b
.word 0x0000501b
.word 0x0000501b
.word 0x4010501b
.word 0x4010501b
.word 0x0000003b
.word 0x0000003b
.word 0x00d0833b
.word 0x00d0833b
.word 0x40d0833b
.word 0x40d0833b
.word 0x00d0933b
.word 0x00d0933b
.word 0x00d0d33b
.word 0x00d0d33b
.word 0x40d0d33b
.word 0x40d0d33b
.word 0x0000100f
.word 0x00431073
.word 0x00431ff3
.word 0xc0132ff3
.word 0xc8133ff3
.word 0x00435ff3
.word 0xc0136ff3
.word 0xc8137ff3
.word 0x02000033
.word 0x02e40733
.word 0x02001033
.word 0x02e41733
.word 0x02002033
.word 0x02e42733
.word 0x02003033
.word 0x02e43733
.word 0x02004033
.word 0x02e44733
.word 0x02005033
.word 0x02e45733
.word 0x02006033
.word 0x02e46733
.word 0x02007033
.word 0x02e47733
.word 0x0200003b
.word 0x02e4073b
.word 0x0200403b
.word 0x02e4473b
.word 0x0200503b
.word 0x02e4573b
.word 0x0200603b
.word 0x02e4673b
.word 0x0200703b
.word 0x02e4773b
.word 0x1000202f
.word 0x1800202f
.word 0x1000302f
.word 0x1800302f
.word 0x0800202f
.word 0x0800302f
.word 0x0000202f
.word 0x0000302f
.word 0x2000202f
.word 0x2000302f
.word 0x6000202f
.word 0x6000302f
.word 0x4000202f
.word 0x4000302f
.word 0x8000202f
.word 0x8000302f
.word 0xa000202f
.word 0xa000302f
.word 0xc000202f
.word 0xc000302f
.word 0xe000202f
.word 0xe000302f
.word 0x00002007
.word 0x00003007
.word 0x00004007
.word 0x00002027
.word 0x00003027
.word 0x00004027
.word 0x00002043
.word 0x02002043
.word 0x06002043
.word 0x00002047
.word 0x02002047
.word 0x06002047
.word 0x0000204b
.word 0x0200204b
.word 0x0600204b
.word 0x0000204f
.word 0x0200204f
.word 0x0600204f
.word 0x00000053
.word 0x00001053
.word 0x00002053
.word 0x00003053
.word 0x00004053
.word 0x00007053
.word 0x02000053
.word 0x06000053
.word 0x08000053
.word 0x0a000053
.word 0x0e000053
.word 0x10000053
.word 0x12000053
.word 0x16000053
.word 0x18000053
.word 0x1a000053
.word 0x1e000053
.word 0x58000053
.word 0x5a000053
.word 0x5e000053
.word 0x20000053
.word 0x20300053
.word 0x22000053
.word 0x22300053
.word 0x26000053
.word 0x26300053
.word 0x20001053
.word 0x20401053
.word 0x22001053
.word 0x22401053
.word 0x26001053
.word 0x26401053
.word 0x20002053
.word 0x20702053
.word 0x22002053
.word 0x22702053
.word 0x26002053
.word 0x26702053
.word 0x29700053
.word 0x2b700053
.word 0x2f700053
.word 0x29701053
.word 0x2b701053
.word 0x2f701053
.word 0xc00332d3
.word 0xc02332d3
.word 0xc20342d3
.word 0xc22342d3
.word 0xc60222d3
.word 0xc62222d3
.word 0xc01332d3
.word 0xc03332d3
.word 0xc21342d3
.word 0xc23342d3
.word 0xc61222d3
.word 0xc63222d3
.word 0xe00503d3
.word 0xe20504d3
.word 0xe60509d3
.word 0xa0340753
.word 0xa0341753
.word 0xa0342753
.word 0xa2340753
.word 0xa2341753
.word 0xa2342753
.word 0xa6340753
.word 0xa6341753
.word 0xa6342753
.word 0xe0091d53
.word 0xe2091d53
.word 0xe6091d53
.word 0xd00e2453
.word 0xd02e2453
.word 0xd01e1453
.word 0xd03e1453
.word 0xd2030553
.word 0xd2130553
.word 0xd6030553
.word 0xd6130553
.word 0xd22e2453
.word 0xd23e1453
.word 0xd62e2453
.word 0xd63e2453
.word 0xf00c0753
.word 0xf20c0753
.word 0xf60c0753
.short 0x1000
.short 0x0800
.short 0x0400
.short 0x0200
.short 0x0100
.short 0x0080
.short 0x0040
.short 0x0020
.short 0x3100
.short 0x2900
.short 0x2500
.short 0x2140
.short 0x2120
.short 0x5100
.short 0x4900
.short 0x4500
.short 0x4140
.short 0x4120
.short 0x7100
.short 0x6900
.short 0x6500
.short 0x6140
.short 0x6120
.short 0xb100
.short 0xa900
.short 0xa500
.short 0xa140
.short 0xa120
.short 0xd100
.short 0xc900
.short 0xc500
.short 0xc140
.short 0xc120
.short 0xf100
.short 0xe900
.short 0xe500
.short 0xe140
.short 0xe120
.short 0x1001
.short 0x1301
.short 0x0341
.short 0x0321
.short 0x0311
.short 0x0309
.short 0x0305
.short 0x2081
.short 0x3081
.short 0x20c1
.short 0x20a1
.short 0x2091
.short 0x2089
.short 0x2085
.short 0x2105
.short 0x2185
.short 0x2205
.short 0x2285
.short 0x2305
.short 0x2385
.short 0x2405
.short 0x2485
.short 0x2505
.short 0x2585
.short 0x2605
.short 0x2685
.short 0x2705
.short 0x2785
.short 0x2805
.short 0x2885
.short 0x2905
.short 0x2985
.short 0x2a05
.short 0x2a85
.short 0x2b05
.short 0x2b85
.short 0x2c05
.short 0x2c85
.short 0x2d05
.short 0x2d85
.short 0x2e05
.short 0x2e85
.short 0x2f05
.short 0x2f85
.short 0x4081
.short 0x5081
.short 0x40c1
.short 0x40a1
.short 0x4091
.short 0x4089
.short 0x4085
.short 0x7101
.short 0x6141
.short 0x6121
.short 0x6111
.short 0x6109
.short 0x6105
.short 0x7301
.short 0x6341
.short 0x6321
.short 0x6311
.short 0x6309
.short 0x6305
.short 0x9001
.short 0x8041
.short 0x8021
.short 0x8011
.short 0x8009
.short 0x8005
.short 0x8405
.short 0x8801
.short 0x9801
.short 0x8941
.short 0x8921
.short 0x8911
.short 0x8909
.short 0x8905
.short 0x8f11
.short 0x8f31
.short 0x8f51
.short 0x8f71
.short 0x9f11
.short 0x9f31
.short 0xa001
.short 0xb001
.short 0xa801
.short 0xa401
.short 0xa201
.short 0xa101
.short 0xa081
.short 0xa041
.short 0xa021
.short 0xa011
.short 0xa009
.short 0xa005
.short 0xc301
.short 0xd301
.short 0xcb01
.short 0xc701
.short 0xc341
.short 0xc321
.short 0xc311
.short 0xc309
.short 0xc305
.short 0xe301
.short 0xf301
.short 0xeb01
.short 0xe701
.short 0xe341
.short 0xe321
.short 0xe311
.short 0xe309
.short 0xe305
.short 0x1302
.short 0x0342
.short 0x0322
.short 0x0312
.short 0x030a
.short 0x0306
.short 0x2702
.short 0x3702
.short 0x2742
.short 0x2722
.short 0x2712
.short 0x270a
.short 0x2706
.short 0x4702
.short 0x5702
.short 0x4742
.short 0x4722
.short 0x4712
.short 0x470a
.short 0x4706
.short 0x6702
.short 0x7702
.short 0x6742
.short 0x6722
.short 0x6712
.short 0x670a
.short 0x6706
.short 0x8302
.short 0x8342
.short 0x9002
.short 0x9502
.short 0x9572
.short 0xa062
.short 0xb062
.short 0xa862
.short 0xa462
.short 0xa262
.short 0xa162
.short 0xa0e2
.short 0xc062
.short 0xd062
.short 0xc862
.short 0xc462
.short 0xc262
.short 0xc162
.short 0xc0e2
.short 0xe062
.short 0xf062
.short 0xe862
.short 0xe462
.short 0xe262
.short 0xe162
.short 0xe0e2
.word 0x00153073
.word 0x0011d073
.word 0x0011e073
EOF
