// KreateCD - CD recording software for the K desktop environment
//
// 1998-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "CDRWBlank.h"
#include "ProgressDialog.h"



#include <qstring.h>
#include <qmessagebox.h>

#include <kprocess.h>
#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>

#include <strings.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include "uidcontrol.h"
#include "pathconfig.h"

extern KLocale *locale;


int CDRWBlank::blankMedia(BlankMode bmode)
 {
  int retval;
  KConfig *config;

  char devline[32],speedline[32];
  int unit,host;

  int speed=2;
  bool simmode=false,eject=false;


  prepareProcess(ProgressDialog::Progress_None);

#if QT_VERSION >= 200
  config=kapp->config();
#else
  config=kapp->getConfig();
#endif
  config->setGroup("SCSI");
  host=config->readNumEntry("SCSIWriterHost",0);
  unit=config->readNumEntry("SCSIWriterUnit",-1);
  if (unit==-1) return(0);

  sprintf(devline,"dev=%d,%d,0",host,unit);
  sprintf(speedline,"speed=%d",speed);
  config->setGroup("Path");
  if ROOT_CALLED
   {
    *this<<config->readEntry("PathCdrecord",PATH_CDRECORD)<<"-v"<<devline<<speedline;
   }
   else
   {
    *this<<PATH_CDRECORD<<"-v"<<devline<<speedline;
   }
  if (simmode) *this<<"-dummy";
  if (eject) *this<<"-eject";

  switch (bmode)
   {
    case Blank_All:
      *this<<"blank=all";
      break;
    case Blank_Fast:
      *this<<"blank=fast";
      break;
    case Blank_Track:
      *this<<"blank=track";
      break;
    case Blank_Unreserve:
      *this<<"blank=unreserve";
      break;
    case Blank_Tail:
      *this<<"blank=trtail";
      break;
    case Blank_Session:
      *this<<"blank=session";
      break;
    case Blank_Unclose:
      *this<<"blank=unclose";
      break;
   }

  setWorkText(locale->translate("Blanking CD-RW media..."));
  addStatusView();

  burnstate=0;

  retval=startProcess();  // 1=ripping was OK  -1=abort -2=ripping error  0=window hard closed

 closeProcess();
  if (retval==-2)
   {
    switch (burnstate)
     {
#if QT_VERSION >= 200
      case 10000:
        QMessageBox::critical(0,QString::null,locale->translate("Cannot access the drive! (no disc?)"));
        break;
      case 10001:
        QMessageBox::critical(0,QString::null,locale->translate("Cannot blank disk!"));
        break;
      default:
        QMessageBox::critical(0,QString::null,locale->translate("Unrecognized error while writing CD-R!!!"));
        break;
#else
      case 10000:
        QMessageBox::critical(0,0,locale->translate("Cannot access the drive! (no disc?)"));
        break;
      case 10001:
        QMessageBox::critical(0,0,locale->translate("Cannot blank disk!"));
        break;
      default:
        QMessageBox::critical(0,0,locale->translate("Unrecognized error while writing CD-R!!!"));
        break;
#endif
     }
   }

  if ( (retval!=1) )
   {
    // workaround : open close writer device to unlock tray
    FILE *xfile;
    QString qs;
    config->setGroup("SCSI");
    qs=config->readEntry("SCSIWriterDevice","/dev/null");
    xfile=fopen(qs.data(),"rb");
    if (xfile!=0) fclose(xfile);
   }

  if (retval!=1) return(0);

  return(1);
 }

int CDRWBlank::processExited(void)
 {
  return(burnstate==0?1:-2);
 }

bool CDRWBlank::processStdoutLine(char *linebuffer)
 {
  printStatusLine(QString(linebuffer));
  return(true);
 }

bool CDRWBlank::processStderrLine(char *linebuffer)
 {
  char *xptr;


  printStatusLine(QString(linebuffer));
  xptr=linebuffer;
  while ( (*xptr!=0) && (*xptr!=':') ) ++xptr;
   if (*xptr!=0)
   {
    xptr++;
    while (*xptr==' ') ++xptr;
    if (strncmp("No disk",xptr,7)==0)
    {
     burnstate=10000;
     return(true);
    }
   if (strncmp("Cannot blank disk, aborting",xptr,27)==0)
   {
    burnstate=10001;
    return(true);
   }
  }
  return(true);
 }
