// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include <qwidget.h>

class ConfPath : public QWidget
 {
  Q_OBJECT;
  public:
    ConfPath( QWidget *parent=0, const char *name=0);
    ~ConfPath(void);
    static int verifyPrograms(void);
    void hide(void);

  signals:
    void closed(void);

  protected:

  protected slots:
         void applySettings(void);
         void okButton(void);
         void cancelButton(void);
         void changeParanoia(void);
         void changeCdrecord(void);
         void changeMkisofs(void);
         void changeCddawav(void);
         void changeTemp(void);

  private:
    class QLineEdit   *ParanoiaPath;
    class QLineEdit   *IsofsPath;
    class QLineEdit   *CdrecordPath;
    class QLineEdit   *CddawavPath;
    class QLineEdit   *TemporaryPath;

    class QLabel   *ParanoiaLabel;
    class QLabel   *IsofsLabel;
    class QLabel   *CdrecordLabel;
    class QLabel   *CddawavLabel;
    class QLabel   *TemporaryLabel;

    class QPushButton  *okbutton;
    class QPushButton  *applybutton;
    class QPushButton  *cancelbutton;
 };


