// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include <qobject.h>
#include <qpixmap.h>

#include <qlistview.h>
#include <qfileinfo.h>
#include <qdir.h>

class FileTree;
class FileTreeItem;
class ISOFile;

class FileTreeItem : public QObject, public QListViewItem
 {
  Q_OBJECT

  public:
    FileTreeItem(QFileInfo *fileinfo,FileTreeItem *parent);
    FileTreeItem(QFileInfo *fileinfo,FileTree *parent);
    FileTreeItem(ISOFile   *isofile,FileTreeItem *parent);
    FileTreeItem(ISOFile   *isofile,FileTree *parent);
    FileTreeItem(FileTreeItem *parent);
    ~FileTreeItem(void);

    bool deleteObject(void);
    bool fileName(QString *filename);
    bool addISOObject(ISOFile *isofile,bool addit=true,bool forceitem=false);

    virtual void setOpen(bool doopen);

  protected:
    void addItemSorted(FileTreeItem *item);
    void expandTree(void);
    void collapseTree(void);
    void expandSubTree(void);
    void collapseSubTree(void);

  private slots:
    void newFiles(const QFileInfoList *infos);
    void dropDummy(void);

  private:
    void setupISOFile(ISOFile *isofile);
    void setupQFileInfo(QFileInfo *fileinfo);

    void setupDirObject(void);

    QFileInfo            *fileObject;
    QDir                 *dirObject;
    QList<FileTreeItem>  *fileList;
    ISOFile              *isoFile;
    bool                  isDirExpanded;
    bool                  isDir;
    FileTreeItem         *dummyItem;
    FileTreeItem         *parentItem;
 };

class FileTree : public QListView
 {
  Q_OBJECT

  public:
    FileTree(QWidget *parent=0,const char *name=0);
    ~FileTree(void);
    void addDir(QFileInfo *finfo);
    void addDir(ISOFile   *isofile);

    bool addRealObject(QString *fname);
    bool createISODir(const char *dirname);
    bool deleteObject(void);

    bool getSelected(QString *fname);

  protected:
    void resizeEvent(QResizeEvent *);


  private slots:
    void changeSelect(QListViewItem *nitem);

  private:
    FileTreeItem *currentItem;
 };

typedef QList<FileTreeItem> FileTreeItems;
