/***************************************************************************
                          kguitune.h  -  description
                             -------------------
    begin                : Sun Jan 16 23:56:00 CET 2000
    copyright            : (C) 2000 by Florian Berger
    email                : florian.berger@jk.uni-linz.ac.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KGUITUNE_H
#define KGUITUNE_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


// include files for KDE 
#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>

// forward declaration of the KGuitune classes
class KGuituneView;

/**
  * The base class for KGuitune application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KGuituneView creates your center view, which is connected
  * to the window's Doc object.
  * KGuituneApp reimplements the methods that KTMainWindow provides for main window handling and supports
  * full session management as well as keyboard accelerator configuration by using KAccel.
	* @see KTMainWindow
	* @see KApplication
	* @see KConfig
	* @see KAccel
	*
	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
	* @version KDevelop version 0.4 code generation
  */
class KGuituneApp : public KTMainWindow
{
  Q_OBJECT

  friend class KGuituneView;

public:
  /** construtor of KGuituneApp, calls all init functions to create the application.
    * @see initMenuBar initToolBar
    */
  KGuituneApp();

  ~KGuituneApp();
  /** enables menuentries/toolbar items
  	*/
  void enableCommand(int id_);
  /** disables menuentries/toolbar items
  	*/
  void disableCommand(int id_);

protected:
 	/** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
		* file
		*/ 	
	void saveOptions();
	/** read general Options again and initialize all variables like the recent file list
	  */
	void readOptions();
	/** initKeyAccel creates the keyboard accelerator items for the available slots and changes the menu accelerators.
		* @see KAccel
		*/
	void initKeyAccel();
  /** initMenuBar creates the menubar and inserts the menupopups as well as creating the helpMenu.
  	* @see KApplication#getHelpMenu
  	*/
  void initMenuBar();
  /** this creates the toolbars.
    */
  void initToolBar();
  /** sets up the statusbar for the main window by initialzing a statuslabel.
  	*/
  void initStatusBar();
  /** creates the centerwidget of the KTMainWindow instance and sets it as the view
  	*/
  void initView();
	/** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
		* Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
		* properties.
		* @see KTMainWindow#queryExit
		* @see KTMainWindow#closeEvent
		*/
	virtual bool queryExit();

 public slots:
  /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);
  /** switch argument for Statusbar help entries on slot selection. Add your ID's help here for toolbars and menubar entries. */
  void statusCallback(int id_);
  /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
  	* If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
  	*/
  void slotFileQuit();
  /** Tuning
  	*/
  void slotTuningNorm();
  /** Tuning
  	*/
  void slotTuningWien();
  /** Tuning
  	*/
  void slotTuningPhys();
  /** Tuning
  	*/
  void slotTuningEqui();
  /** Tuning
  	*/
  void slotTuningNat();
  /** Note Scale
  	*/
  void slotScaleUS();
  /** Note Scale
  	*/
  void slotScaleUSAlt();
  /** Note Scale
  	*/
  void slotScaleGE();
  /** Note Scale
  	*/
  void slotScaleGEAlt();
  /** Sound Otions
  	*/
  void slotOptionsSound();
  /** Starts kmix
  	*/
  void slotOptionsRunMixer();
  /** toggles the toolbar
  	*/
  void slotViewToolBar();
  /** toggles the statusbar
  	*/
  void slotViewStatusBar();
  /** toggles the OSZI On/Off
  	*/
  void slotViewOSZI();
  /** toggles the NoteScale On/Off
  	*/
  void slotViewNoteScale();
  /** changes the statusbar contents for the Sample Frequency-item
  	*/
  void slotStatusSF();
  /** changes the statusbar contents for the Sample Number-item
  	*/
  void slotStatusSN();
  /** changes the statusbar contents for the Trigger-item
  	*/
  void slotStatusTR();
  /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
  	* @param text the text that is displayed in the statusbar
  	*/
  void slotStatusMsg(const char *text);
  /** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
		* statusbar messages that give information about actions for toolbar icons and menuentries.
  	* @param text the text that is displayed in the statusbar
   	*/
  void slotStatusHelpMsg(const char *text);

private:
	/** the configuration object of the application */
	KConfig* config;
	/** the key accelerator container */
	KAccel* key_accel;
  /** file_menu contains all items of the menubar entry "File" */
  QPopupMenu *file_menu;
  /** tuning_menu contains all items of the options_menu entry "Tuning" */
  QPopupMenu *tuning_menu;
  /** scale_menu contains all items of the options_menu entry "Note Scale" */
  QPopupMenu *scale_menu;
  /** options_menu contains all items of the menubar entry "Options" */
  QPopupMenu *options_menu;
  /** view_menu contains all items of the menubar entry "View" */
  QPopupMenu *view_menu;
  /** help_menu contains all items of the menubar entry "Help" */
  QPopupMenu *help_menu;
  /** view is the main widget which represents your working area. The View
    * class should handle all events of the view widget.  It is kept empty so
    * you can create your view according to your application's needs by
    * changing the view class. */
  KGuituneView *view;
	QString dsp_devicename;

};
 
#endif // KGUITUNE_H

























































