/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.conf;

import com.mysql.cj.api.conf.RuntimeProperty;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.core.conf.AbstractPropertyDefinition;
import com.mysql.cj.core.conf.ModifiableBooleanProperty;
import com.mysql.cj.core.conf.ReadableBooleanProperty;

public class BooleanPropertyDefinition
extends AbstractPropertyDefinition<Boolean> {
    private static final long serialVersionUID = -7288366734350231540L;

    public BooleanPropertyDefinition(String name, Boolean defaultValue, boolean isRuntimeModifiable, String description, String sinceVersion, String category, int orderInCategory) {
        super(name, defaultValue, isRuntimeModifiable, description, sinceVersion, category, orderInCategory);
    }

    @Override
    public String[] getAllowableValues() {
        return new String[]{"true", "false", "yes", "no"};
    }

    @Override
    public Boolean parseObject(String value, ExceptionInterceptor exceptionInterceptor) {
        this.validateAllowableValues(value, exceptionInterceptor);
        return value.equalsIgnoreCase("TRUE") || value.equalsIgnoreCase("YES");
    }

    @Override
    public RuntimeProperty<Boolean> createRuntimeProperty() {
        return this.isRuntimeModifiable() ? new ModifiableBooleanProperty(this) : new ReadableBooleanProperty(this);
    }
}

