
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQLoggingCategory.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QLoggingCategory>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QLoggingCategory

//  Constructor QLoggingCategory::QLoggingCategory(const char *category)


static void _init_ctor_QLoggingCategory_1731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("category");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return_new<QLoggingCategory> ();
}

static void _call_ctor_QLoggingCategory_1731 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<QLoggingCategory *> (new QLoggingCategory (arg1));
}


//  Constructor QLoggingCategory::QLoggingCategory(const char *category, QtMsgType severityLevel)


static void _init_ctor_QLoggingCategory_2969 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("category");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("severityLevel");
  decl->add_arg<const qt_gsi::Converter<QtMsgType>::target_type & > (argspec_1);
  decl->set_return_new<QLoggingCategory> ();
}

static void _call_ctor_QLoggingCategory_2969 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const qt_gsi::Converter<QtMsgType>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QtMsgType>::target_type & >() (args, heap);
  ret.write<QLoggingCategory *> (new QLoggingCategory (arg1, qt_gsi::QtToCppAdaptor<QtMsgType>(arg2).cref()));
}


// const char *QLoggingCategory::categoryName()


static void _init_f_categoryName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const char * > ();
}

static void _call_f_categoryName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const char * > ((const char *)((QLoggingCategory *)cls)->categoryName ());
}


// bool QLoggingCategory::isCriticalEnabled()


static void _init_f_isCriticalEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isCriticalEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QLoggingCategory *)cls)->isCriticalEnabled ());
}


// bool QLoggingCategory::isDebugEnabled()


static void _init_f_isDebugEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDebugEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QLoggingCategory *)cls)->isDebugEnabled ());
}


// bool QLoggingCategory::isEnabled(QtMsgType type)


static void _init_f_isEnabled_c1346 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QtMsgType>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isEnabled_c1346 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QtMsgType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QtMsgType>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QLoggingCategory *)cls)->isEnabled (qt_gsi::QtToCppAdaptor<QtMsgType>(arg1).cref()));
}


// bool QLoggingCategory::isInfoEnabled()


static void _init_f_isInfoEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isInfoEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QLoggingCategory *)cls)->isInfoEnabled ());
}


// bool QLoggingCategory::isWarningEnabled()


static void _init_f_isWarningEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWarningEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QLoggingCategory *)cls)->isWarningEnabled ());
}


// QLoggingCategory &QLoggingCategory::operator()()


static void _init_f_operator_func__0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLoggingCategory & > ();
}

static void _call_f_operator_func__0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLoggingCategory & > ((QLoggingCategory &)((QLoggingCategory *)cls)->operator() ());
}


// const QLoggingCategory &QLoggingCategory::operator()()


static void _init_f_operator_func__c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QLoggingCategory & > ();
}

static void _call_f_operator_func__c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QLoggingCategory & > ((const QLoggingCategory &)((QLoggingCategory *)cls)->operator() ());
}


// void QLoggingCategory::setEnabled(QtMsgType type, bool enable)


static void _init_f_setEnabled_2102 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QtMsgType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enable");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setEnabled_2102 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QtMsgType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QtMsgType>::target_type & >() (args, heap);
  bool arg2 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLoggingCategory *)cls)->setEnabled (qt_gsi::QtToCppAdaptor<QtMsgType>(arg1).cref(), arg2);
}


// static QLoggingCategory *QLoggingCategory::defaultCategory()


static void _init_f_defaultCategory_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QLoggingCategory * > ();
}

static void _call_f_defaultCategory_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLoggingCategory * > ((QLoggingCategory *)QLoggingCategory::defaultCategory ());
}


// static void QLoggingCategory::setFilterRules(const QString &rules)


static void _init_f_setFilterRules_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rules");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilterRules_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QLoggingCategory::setFilterRules (arg1);
}



namespace gsi
{

static gsi::Methods methods_QLoggingCategory () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLoggingCategory::QLoggingCategory(const char *category)\nThis method creates an object of class QLoggingCategory.", &_init_ctor_QLoggingCategory_1731, &_call_ctor_QLoggingCategory_1731);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLoggingCategory::QLoggingCategory(const char *category, QtMsgType severityLevel)\nThis method creates an object of class QLoggingCategory.", &_init_ctor_QLoggingCategory_2969, &_call_ctor_QLoggingCategory_2969);
  methods += new qt_gsi::GenericMethod ("categoryName", "@brief Method const char *QLoggingCategory::categoryName()\n", true, &_init_f_categoryName_c0, &_call_f_categoryName_c0);
  methods += new qt_gsi::GenericMethod ("isCriticalEnabled?", "@brief Method bool QLoggingCategory::isCriticalEnabled()\n", true, &_init_f_isCriticalEnabled_c0, &_call_f_isCriticalEnabled_c0);
  methods += new qt_gsi::GenericMethod ("isDebugEnabled?", "@brief Method bool QLoggingCategory::isDebugEnabled()\n", true, &_init_f_isDebugEnabled_c0, &_call_f_isDebugEnabled_c0);
  methods += new qt_gsi::GenericMethod ("isEnabled?", "@brief Method bool QLoggingCategory::isEnabled(QtMsgType type)\n", true, &_init_f_isEnabled_c1346, &_call_f_isEnabled_c1346);
  methods += new qt_gsi::GenericMethod ("isInfoEnabled?", "@brief Method bool QLoggingCategory::isInfoEnabled()\n", true, &_init_f_isInfoEnabled_c0, &_call_f_isInfoEnabled_c0);
  methods += new qt_gsi::GenericMethod ("isWarningEnabled?", "@brief Method bool QLoggingCategory::isWarningEnabled()\n", true, &_init_f_isWarningEnabled_c0, &_call_f_isWarningEnabled_c0);
  methods += new qt_gsi::GenericMethod ("()", "@brief Method QLoggingCategory &QLoggingCategory::operator()()\n", false, &_init_f_operator_func__0, &_call_f_operator_func__0);
  methods += new qt_gsi::GenericMethod ("()", "@brief Method const QLoggingCategory &QLoggingCategory::operator()()\n", true, &_init_f_operator_func__c0, &_call_f_operator_func__c0);
  methods += new qt_gsi::GenericMethod ("setEnabled", "@brief Method void QLoggingCategory::setEnabled(QtMsgType type, bool enable)\n", false, &_init_f_setEnabled_2102, &_call_f_setEnabled_2102);
  methods += new qt_gsi::GenericStaticMethod ("defaultCategory", "@brief Static method QLoggingCategory *QLoggingCategory::defaultCategory()\nThis method is static and can be called without an instance.", &_init_f_defaultCategory_0, &_call_f_defaultCategory_0);
  methods += new qt_gsi::GenericStaticMethod ("setFilterRules", "@brief Static method void QLoggingCategory::setFilterRules(const QString &rules)\nThis method is static and can be called without an instance.", &_init_f_setFilterRules_2025, &_call_f_setFilterRules_2025);
  return methods;
}

gsi::Class<QLoggingCategory> decl_QLoggingCategory ("QtCore", "QLoggingCategory",
  methods_QLoggingCategory (),
  "@qt\n@brief Binding of QLoggingCategory");


GSI_QTCORE_PUBLIC gsi::Class<QLoggingCategory> &qtdecl_QLoggingCategory () { return decl_QLoggingCategory; }

}

