- [76. Use Schlundtech](#dns_schlundtech)
- [77. Use your one.com credentials as you would login into the control panel.](#dns_one)
- [78. Use AcmeProxy DNS API](#dns_acmeproxy)
- [79. Use internetbs.net API](#dns_internetbs)
- [80. Use durabledns.com API](#dns_durabledns)
- [81. Use reg.ru API](#dns_regru)
- [82. Use Vultr DNS API to automatically issue cert](#dns_vultr)
- [83. Use jdcloud.com DNS API to automatically issue cert](#dns_jd)
- [84. Use hexonet.net DNS API to automatically issue a cert](#dns_hexonet)
- [85. Use Domeneshop DNS API to automatically issue a cert](#dns_domeneshop)
- [86. Use OPNsense embedded API to automatically issue cert](#dns_opnsense)
- [87. Use the RcodeZero API to automatically issue cert](#dns_rcode0)
- [88. Use MailinaBox](#dns_miab)
- [89. Use nic.ru DNS](#dns_nic)
- [90. Use Leaseweb.com domain API to automatically issue cert](#dns_leaseweb)
- [91. Use variomedia.de domain API to automatically issue cert](#dns_variomedia)
- [92. Use Plesk XML API to automatically issue cert](#dns_pleskxml)
- [93. Use PDNS Manager API](#dns_pdnsmanager)
- [94. Use Misaka.io domain API](#dns_misaka)
- [95. Use easyDNS.net API to automatically issue a cert](#dns_easydns)
- [96. Use CloudDNS API to automatically issue a cert](#dns_clouddns)
- [97. Use dynv6 API to automatically issue a cert](#dns_dynv6)
- [98. Use All-Inkl.com domain API to automatically issue cert](#dns_kas)
- [99. Use Constellix domain API](#dns_constellix)
- [100. Use Namemaster domain API](#dns_nm)
- [101. Use HostingUkraine domain API](#dns_hostingukraine)
- [102. Use ArvanCloud domain API](#dns_arvan)
- [103. Use Joker.com domain API](#dns_joker)
- [104. Use 1984Hosting domain API](#dns_1984hosting)
- [105. Use Aruba domain API](#dns_aruba)
- [106. Use TransIP domain API:](#dns_transip)
- [107. Use dyndnsfree.de API](#dns_df)
- [108. Use Njalla API](#dns_njalla)
- [109. Use Vercel API](#dns_vercel)
- [110. Use Hetzner DNS API](#dns_hetzner)
- [111. Use kapper.net DNS API](#dns_kappernet)
- [112. -------](-------)
- [113. Use Shellrent API](#dns_shellrent)
- [114. Use OpenStack domain API](#dns_openstack)
- [115. Use Netlify API](#dns_netlify)
- [116. Use Akamai Edge DNS API](#dns_edgedns)
- [117. Use WEDOS DNS API](#dns_wedos)
- [118. Use Websupport DNS API](#dns_websupport)
- [119. Use infomaniak.com API](#dns_infomaniak)
- [120. Use bookmyname.com API](#dns_bookmyname)
- [121. Use anexia.com CloudDNS API](#dns_anx)
- [122. Use Synology DSM Synology DNS Server API](#dns_synology_dsm)
- [123. Use HuaweiCloud API](#dns_huaweicloud)
- [124. Use Simply.com API](#dns_simply)
- [125. Use World4You API](#dns_world4you)
- [126. Use Scaleway API](#dns_scaleway)
- [128. Use RackCorp API](#dns_rackcorp)
- [129. Using the IONOS domain API](#dns_ionos)
- [130. Using the Porkbun API](#dns_porkbun)
- [131. Using the Aurora API](#dns_aurora)
- [132. Using the Azion DNS API](#dns_azion)
- [133. Using Oracle Cloud Infrastructure DNS](#dns_oci)
- [134. Utilisation de l'API DNS Hostline Hébergement VPS](#dns_hostline)
- [135. Use Veesp domain API](#dns_veesp)
- [136. Use cPanel DNS systems](#dns_cpanel)
- [137. Use ISPMan domain API](#dns_ispman)
- [138. Use dnsHome.de DNS API](#dns_dnshome)
- [139. Use mythic-beasts.com DNS API](#dns_mythic_beasts)
- [140. Use s-dns.de API](#dns_sdns)
- [141. Using the united-domains reselling DNS API](#dns_udr)
- [142. Using the curanet DNS API](#dns_curanet)
- [143. Use ArtFiles.de DNS API](#dns_artfiles)
- [144. Use Geoscaling.com DNS2](#dns_geoscaling)
- [145. Use fornex.com API](#dns_fornex)
- [146. Use DNS.Services API](#dns_dnsservices)
- [147. Use Nodion DNS API](#dns_nodion)
- [148. Use dns.la API](#dns_la)
- [149. Use Yandex Cloud DNS API](#dns_yc)
- [150. Use Bunny DNS API to automatically issue cert](#dns_bunny)
- [151. Use Selfhost DNS API](#dns_selfhost)
- [152. Use rage4 DNS API](#dns_rage4)
- [153. Use GCore DNS API](#dns_gcore)
- [154. Use dynadot DNS API](#dns_dynadot)
- [155. Use IPv64 DNS API](#dns_ipv64)
- [156. Use Nanelo DNS API](#dns_nanelo)
- [157. Use Google Domains DNS API](#dns_googledomains)
- [158. Use DNSExit API](#dns_dnsexit)
- [159. Use Lima-City (Trafficplex)](#dns_limacity)
- [160. Use  TencentCloud (DNSPod) API](#dns_tencent)
- [161. Use Samba AD DC API](#dns_samba)
- [162. Use West.cn API](#dns_west_cn)
- [163. Use hosttech API](#dns_hosttech)
- [164. Use Alviy API](#dns_alviy)
- [165. Use Timeweb Cloud DNS API](#dns_timeweb)
- [166. Use myLoc.de / webtropia.com DNS API](#dns_myloc)
- [167. Use Yandex 360 for Business DNS API](#dns_yandex360)
- [168. Use HE DNS DDNS API](#dns_he_ddns)
- [169. Using the IONOS Cloud DNS API](#dns_ionos_cloud)
- [170. Use omg.lol API](#dns_omglol)
- [171. Use Power-MailinaBox](#dns_pmiab)
- [172. Use Technitium DNS Server API](#dns_technitium)
- [173. Use ZoneEdit DNS API](#dns_zoneedit)
- [174. Use Anikeen Cloud DNS API](#dns_anikeen)
- [175. Use mijn.host DNS API](#dns_mijnhost)
- [176. Use OpenProvider (REST) DNS API](#dns_openprovider_rest)
- [177. Use Beget.com DNS API](#dns_beget)
- [Use custom API](#dns_myapi)
- [Use lexicon DNS API](#dns_lexicon)



<a name="dns_schlundtech"/>

## 76. Use Schlundtech

[Schlundtech](https://www.schlundtech.de/) offers a [xml api](https://www.schlundtech.de/services/xml-gateway/) with your standard login credentials, set them like so:

```sh
export SCHLUNDTECH_USER="yourusername"
export SCHLUNDTECH_PASSWORD="password"
```

Then you can issue your certificates with:

```sh
./acme.sh --issue --dns dns_schlundtech -d example.com -d *.example.com
```

The `SCHLUNDTECH_USER` and `SCHLUNDTECH_PASSWORD` settings will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2246)


<a name="dns_one"/>

## 77. Use your one.com credentials as you would login into the control panel.

```sh
export ONECOM_User="<username>"
export ONECOM_Password="youremail@example.com"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_one -d example.com -d *.example.com
```

Note:
It's no longer possible to add TXT Records with the Name `_acme-challenge` to the base Domain.  
To override the fallback value, you must use a CNAME and proxy it.  
For example:  

    CNAME _acme-challenge.yourdomain.com => proxy_acme-challenge.yourdomain.com  

The TXT Records have to be created on `proxy_acme-challenge.yourdomain.com`.  
Since the default CNAME TTL is 3600 seconds, it is recommended to leave the CNAME record.  
But if you would like to use the build-in SSL (for your Web-Site etc.) from one.com, you have to delete the Record.

You can set `ONECOM_KeepCnameProxy` to keep the CNAME record.

```sh
export ONECOM_KeepCnameProxy=1
```

By default the CNAME record will be removed.

The `ONECOM_User`,`ONECOM_Password` and `ONECOM_KeepCnameProxy` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2103)


<a name="dns_acmeproxy"/>

## 78. Use AcmeProxy DNS API

[Acmeproxy](https://github.com/mdbraber/acmeproxy/) can be used to as a single host in your network to request certificates through a DNS API.
Clients can connect with one single host (the acmeproxy) so you don't need to store your DNS API credentials on every single host that wants to request a certificate.

```sh
export ACMEPROXY_ENDPOINT="https://acmeproxy.yourhost.com:9096"
export ACMEPROXY_USERNAME="username"
export ACMEPROXY_PASSWORD="password"
```

Then you can issue your certificates with:

```sh
./acme.sh --issue --dns dns_acmeproxy -d example.com -d *.example.com
```

The `ACMEPROXY_ENDPOINT`, `ACMEPROXY_USERNAME` and `ACMEPROXY_PASSWORD` settings will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2251)


<a name="dns_internetbs"/>

## 79. Use internetbs.net API

Create an API token in your internetbs.net account.

Set your API token:
```sh
export INTERNETBS_API_KEY="..."
export INTERNETBS_API_PASSWORD="..."
```

To issue a certificate run:
```sh
./acme.sh --issue --dns dns_internetbs -d example.com -d *.example.com
```

The `INTERNETBS_API_KEY` and `INTERNETBS_API_PASSWORD` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2261)


<a name="dns_durabledns"/>

## 80. Use durabledns.com API

Create an API token in your durabledns.com account.

Set your API token:
```sh
export DD_API_User="..."
export DD_API_Key="..."
```

To issue a certificate run:
```sh
./acme.sh --issue --dns dns_durabledns -d example.com -d '*.example.com'
```

The `DD_API_User` and `DD_API_Key` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2281)


<a name="dns_regru"/>

## 81. Use reg.ru API

Set your API credentials:
```sh
export REGRU_API_Username='test'
export REGRU_API_Password='test'
```

To issue a certificate run:
```sh
./acme.sh --issue --dns dns_regru -d 'example.com' -d '*.example.com'
```

The `REGRU_API_Username` and `REGRU_API_Password` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2336)

RU:

Установите свои учетные данные API:

В [Настройки API](https://www.reg.ru/user/account/#/settings/api/) для авторизации устанавливаем пароль в настройках "Альтернативный пароль", и добавляем IP в "Диапазоны IP-адресов" для избежание ошибки
```
response='{
   "charset" : "utf-8",
   "error_code" : "ACCESS_DENIED_FROM_IP",
   "error_params" : {
      "command_name" : "service/get_list"
   },
   "error_text" : "Access to API from this IP denied",
   "messagestore" : null,
   "result" : "error"
}'
```
Диапазоны IP-адресов
acme-v02.api.letsencrypt.org - `172.65.32.248` для получения SSL и api.reg.ru - `194.58.116.30` для тхт записи _acme-challenge

Для авторизатции в API выполните:
```sh
export REGRU_API_Username='водим свой логин для входа на REG.RU'
export REGRU_API_Password='водим пароль каторый настроили в настройках API для авторизации'
```
Для получения сертификата выполните:
```sh
./acme.sh --issue --dns dns_regru -d example.com -d *.example.com
```
Настройки для авторизации `REGRU_API_Username` и `REGRU_API_Password` будут сохранены в `~/.acme.sh/account.conf` и будут использоваться повторно при необходимости из конфига acme.

Если вы обнаружите какие-либо ошибки в API reg.ru, сообщите об этом [здесь](https://github.com/acmesh-official/acme.sh/issues/2336)


<a name="dns_vultr"/>

## 82. Use Vultr DNS API to automatically issue cert

You'll need an API key for your Vultr account which you can find [under the Account settings](https://my.vultr.com/settings/#settingsapi).
And you'll want to ensure the API key is allowed for any IPs you might be using acme.sh with.

Vultr supports creating sub-accounts with limited permissions, and it's a good idea to create a sub-account with only the 'Manage DNS' permission and use an API key from that sub-account.

```sh
export VULTR_API_KEY="<Your API key>"
```

To issue a cert:

```sh
./acme.sh --issue --dns dns_vultr -d example.com -d *.example.com
```

The `VULTR_API_KEY` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2374)


<a name="dns_jd"/>

## 83. Use jdcloud.com DNS API to automatically issue cert

支持京东云 jdcloud.com 的免费dns服务.  请先登陆控制台获取 api key id 和 api key secret:

https://uc.jdcloud.com/account/accesskey

```sh
export JD_ACCESS_KEY_ID="<key id>"
export JD_ACCESS_KEY_SECRET="<secret>"
```

然后生成证书:

```sh
./acme.sh --issue --dns dns_jd  -d example.com -d *.example.com
```

`JD_ACCESS_KEY_ID` 和 `JD_ACCESS_KEY_SECRET` 会自动保存在这里 `~/.acme.sh/account.conf`, 下次再生成证书时, 可以自动重用.

高级选项:
1. 默认使用的是 `cn-north-1` 区域. 目前不需要改动, 如果需要改的话, 再生成证书之前执行:
```sh
export JD_REGION="cn-north-1" # 这里写你要改的区域
```

有 bug 的话可以报到这里: https://github.com/acmesh-official/acme.sh/issues/2388


<a name="dns_hexonet"/>

## 84. Use hexonet.com DNS API to automatically issue a cert

Login to hexonet.net.
Create a role user in your [Account -> Settings -> ShareAccess](https://account.hexonet.net/#/role-accounts)

Set the Access Control like bellow:
```
QueryDNSZoneRRList(dnszone=*):ALLOW
UpdateDNSZone():ALLOW
```

Remember the role id and role password.

```sh
export Hexonet_Login="user!role"
export Hexonet_Password="<role password>"
```

For example:
My username is `neilpang`, my role id is: `testid`. So I use the following format:

```sh
export Hexonet_Login='neilpang!testid'
```

To issue a cert:

```sh
./acme.sh --issue --dns dns_hexonet -d example.com -d *.example.com
```

The `Hexonet_Login` and `Hexonet_Password` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2389)


<a name="dns_domeneshop"/>

## 85. Use Domeneshop DNS API to automatically issue a cert

You'll have to get a Domeneshop API key and secret (https://api.domeneshop.no/docs/).

```sh
export DOMENESHOP_Token="<token>"
export DOMENESHOP_Secret="<secret>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_domeneshop -d example.com -d *.example.com
```

The `DOMENESHOP_Token` and `DOMENESHOP_Secret` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2457)


<a name="dns_opnsense"/>

## 86. Use OPNsense embedded API to automatically issue cert

First you need to login to your OPNsense account and create an API Key for a user with access to the Bind service.

https://docs.opnsense.org/development/api.html

```sh
export OPNs_Host="opnsense.example.com"
export OPNs_Port="443"
export OPNs_Key="qocfU9RSbt8vTIBcnW8bPqCrpfAHMDvj5OzadE7Str+rbjyCyk7u6yMrSCHtBXabgDDXx/dY0POUp7ZA"
export OPNs_Token="pZEQ+3ce8dDlfBBdg3N8EpqpF5I1MhFqdxX06le6Gl8YzyQvYCfCzNaFX9O9+IOSyAs7X71fwdRiZ+Lv"
export OPNs_Api_Insecure=0
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_opnsense -d example.com -d *.example.com
```

The `OPNs_Host`, `OPNs_Port`, `OPNs_Key`, `OPNs_Token` and `OPNs_Api_Insecure` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2480)


<a name="dns_rcode0"/>

## 87. Use the RcodeZero API to automatically issue cert

First you need to login to your RcodeZero account, enable the REST API and generate an ACME API token.
Only the ACME API token will work wih acme.sh. It has limited access and could only be used to add/remove challenges to the zones.

https://my.rcodezero.at/ &rarr; Settings &rarr; API

```sh
export RCODE0_API_TOKEN="acme_1232342342343OEH1G1gDcKNMsN7mx9EZgSU6AX79u5KRSxWnC"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_rcode0 -d example.com -d *.example.com
```

The `RCODE0_API_TOKEN` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

The RcodeZero API driver supports two addtional environment variables
```sh
export RCODE0_URL="https://my.rcodezero.at"
```
Use a different RcodeZero API Endpoint (e.g. the RcodeZero Testsystem)
```sh
export RCODE0_TTL=60
```
Use a different TTL for the generated records

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2490)


<a name="dns_miab"/>

## 88. Use MailinaBox

Use the Mail-In-a-Box (MIAB) Custom DNS REST API interface to MIAB DNS.
You only need to set your MIAB login credentials and the fully qualified domain name of the MIAB Server.
Suggest single quote over double quote to ensure characters are not interpreted by the shell - important for passwords.

```sh
export MIAB_Username='your_MIAB_admin_username'
export MIAB_Password='your_MIAB_admin_password'
export MIAB_Server='FQDN_of_your_MIAB_Server'
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_miab -d example.com -d *.example.com
```

The `MIAB_Username`, `MIAB_Password` and `MIAB_Server` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2550)


<a name="dns_nic"/>

## 89. Use nic.ru DNS
You need to login to nic.ru account and register your application [here](https://www.nic.ru/manager/oauth.cgi?step=oauth.app_register).

You need to define the following environment variables befor issuing a cert:
* `NIC_Username` - login for site `nic.ru` in form `000000/NIC-D`
* `NIC_Password` - password for site `nic.ru`. It may be administrative or technical password. [Details](https://www.nic.ru/help/use-of-administrative-and-technical-passwords-according-to-the-agreement_6148.html)
* `NIC_ClientID` - your application identifier ([details](https://www.nic.ru/help/oauth-server_5809.html))
* `NIC_ClientSecret` - your application secret
* _`NIC_Token` is base64 encoded string `<client_id>:<client_secret>`. **This variable is deprecated**. It is used for backward compatibility. If NIC_ClientID and NIC_ClientSecret are not defined, then they are calculated using old NIC_Token variable._

```bash
export NIC_Username='000000/NIC-D'
export NIC_Password='xxxxxxxx'
export NIC_ClientID='xxxxxxxx'
export NIC_ClientSecret='xxxxxxxx'
```

To issue a cert:
```bash
./acme.sh --issue --dns dns_nic -d domain.com -d *.domain.com
```

The `NIC_Username`, `NIC_Password`, `NIC_ClientID` and `NIC_ClientSecret` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2547)

Docs:
* https://www.nic.ru/help/upload/file/API_DNS-hosting-en.pdf
* https://www.nic.ru/help/oauth-server_5809.html


<a name="dns_leaseweb"/>

## 90. Use Leaseweb.com domain API to automatically issue cert

First you need to login to your Leaseweb account to get your API Key.

```sh
export LSW_Key="<key>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_leaseweb -d example.com -d *.example.com
```

The `LSW_Key` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2558)



<a name="dns_variomedia"/>

## 91. Use variomedia.de domain API to automatically issue cert

First you need to obtain your API Key from variomedia's customer support.

```sh
export VARIOMEDIA_API_TOKEN="<token>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_variomedia -d example.com -d *.example.com
```

The `VARIOMEDIA_API_TOKEN` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2564)


<a name="dns_pleskxml"/>

## 92. Use Plesk XML API to automatically issue cert

Before using the module, you must set your Plesk username and password,
and the address of your Plesk XML API (sometimes called a URI, URL or web link).

The URI usually looks similar to this:

```
https://address-of-my-plesk-server.net:8443/enterprise/control/agent.php
```

All commands are CASE SENSITIVE:

```sh
export pleskxml_uri="address of my Plesk server's API"
export pleskxml_user="my plesk username"
export pleskxml_pass="my plesk password"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_pleskxml -d example.com -d *.example.com
```

The `pleskxml_uri`, `pleskxml_user` and `pleskxml_pass` will be saved in `~/.acme.sh/account.conf` and reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2577)


<a name="dns_pdnsmanager"/>

## 93. Use PDNS Manager API

[PDNS Manager](https://pdnsmanager.org/) is a web frontend for [Power DNS](https://www.powerdns.com/).

This script uses PDNS Manager API and its [Update via GET request](https://pdnsmanager.org/documentation/api/) method.
So only single record update possible and no wildcards, for now.

```sh
export PDNS_MANAGER_URL="https://mypdnsmanagerurl.nx"
export PDNS_MANAGER_RECORDID="<record id>"
export PDNS_MANAGER_PASSWORD="<record password>"
```

* Add your domain to PDNS Manager.
* [Create a password](https://pdnsmanager.org/documentation/api/) for your record.

Then issue a new certificate:

```sh
./acme.sh --issue --dns dns_pdnsmanager -d example.com -d *.example.com
```


<a name="dns_misaka"/>

## 94. Use Misaka.io domain API

Get your API token at https://console.misaka.io/settings

```sh
export Misaka_Key="<key>"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_misaka -d example.com -d *.example.com
```


<a name="dns_easydns"/>

## 95. Use easyDNS.net API to automatically issue a cert
You need to sign up for API access [here](https://cp.easydns.com/manage/security/api/signup.php).  
Or select 'User' -> 'Security' from the top menu and select 'signup' in the 'easyDNS REST API' section after logging in to your account.

API Docs: https://sandbox.rest.easydns.net:3001/

Note that initially you are only granted API access to a sandbox environment, not your live DNS settings.

```sh
export EASYDNS_Token="xxxxxxxxxxxxxxx.xxxxxxxx"
export EASYDNS_Key="apixxxxxxxxxxxxxx.xxxxxxxx"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_easydns -d example.com -d *.example.com
```
The `EASYDNS_Token` and `EASYDNS_Key` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2647)


<a name="dns_clouddns"/>

## 96. Use CloudDNS API to automatically issue a cert
Docs: https://github.com/vshosting/clouddns

```sh
export CLOUDDNS_EMAIL="email@example.com"
export CLOUDDNS_PASSWORD="xxxxxxxx"
export CLOUDDNS_CLIENT_ID="xxxxxxxxxxxxxxxxxxxx"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_clouddns -d example.com -d *.example.com
```
The `CLOUDDNS_EMAIL`, `CLOUDDNS_PASSWORD` and `CLOUDDNS_CLIENT_ID` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2699)


<a name="dns_dynv6"/>

## 97. Use dynv6 API to automatically issue a cert
This uses the [HTTP REST API](https://dynv6.github.io/api-spec/).
For this you will need a HTTP Token, which you can generate from the [dynv6 website](https://dynv6.com/keys).
Use it with `export DYNV6_TOKEN="value"`.

Alternatively you can use the [dynv6 SSH API](https://dynv6.com/docs/apis) to issue the certificate.
You will need a ssh key to authenticate.
You can specify your own key with `export KEY="path/to/keyfile"` or if no key is specified one will be created for you which you will have to add [here](https://dynv6.com/keys).
In both cases the path to the keyfile will be saved for reuse.

If both a SSH Key and a HTTP Token are specified the REST API will be used.

To issue a cert use:
```sh
./acme.sh --issue --dns dns_dynv6 -d example.dynv6.net -d *.example.dynv6.net
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2702)


<a name="dns_kas"/>

## 98. Use All-Inkl.com domain API to automatically issue cert

You need your login credentials for All-Inkl (https://kas.all-inkl.com).
```sh
export KAS_Login="<ACCOUNTID>" 
export KAS_Authdata="<PLAINTEXTPASSWORD>"
export KAS_Authtype="plain"
```
Now you are able to issue a cert:
```sh
./acme.sh --issue --dns dns_kas -d example.com -d *.example.com
```
The `KAS_Login`, `KAS_Authtype` and `KAS_Authdata` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2715)

<a name="dns_constellix"/>

## 99. Use Constellix domain API

Get your API credentials at https://manage.constellix.com/users

```sh
export CONSTELLIX_Key="XXX"
export CONSTELLIX_Secret="XXX"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_constellix -d example.com -d *.example.com
```

The `CONSTELLIX_Key` and `CONSTELLIX_Secret` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2724)

<a name="dns_nm"/>

## 100. Use Namemaster domain API

Get your API credentials at https://namemaster.de DNS/API

```sh
export NM_user="XXX"
export NM_sha256="XXX"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_nm -d example.com -d *.example.com
```

The `NM_user` and `NM_sha256` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_hostingukraine"/>

## 101. Use HostingUkraine domain API

How get your API credentials: https://api.adm.tools/osnovnie-polozheniya/dostup-k-api/

```
# Your login:
HostingUkraine_Login="XXX"
# Your api token:
HostingUkraine_Token="XXX"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_hostingukraine -d example.com -d *.example.com 
```

The `HostingUkraine_Login` and `HostingUkraine_Token` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2683)

<a name="dns_arvan"/>

## 102. Use ArvanCloud domain API

Get your API token at https://npanel.arvancloud.ir/profile/api-keys

```sh
export Arvan_Token="<token>"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_arvan -d example.com -d *.example.com
```

The `Arvan_Token` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2796)


<a name="dns_joker"/>

## 103. Use Joker.com domain API

You must activate Dynamic DNS in Joker.com DNS configuration first.
Username and password below refer to Dynamic DNS authentication, not your Joker.com login credentials.
See https://joker.com/faq/content/11/427/en/what-is-dynamic-dns-dyndns.html.

**NOTE:** This script does not support wildcard certificates, because Joker.com API does not support adding two TXT records with the same subdomain.
Adding the second record will overwrite the first one.
See https://joker.com/faq/content/6/496/en/let_s-encrypt-support.html:
> ... this request will replace all TXT records for the specified label by the provided content...

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2840)

```sh
export JOKER_USERNAME="xxxx"
export JOKER_PASSWORD="xxxx"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_joker -d example.com -d *.example.com
```

The `JOKER_USERNAME` and `JOKER_PASSWORD` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_1984hosting"/>

## 104. Use 1984Hosting domain API

https://1984.hosting/ does not provide an API to update DNS records
(other than IPv4 and IPv6 dynamic DNS addresses). The `acme.sh` plugin therefore
retrieves and updates domain TXT records by logging into the 1984Hosting
website to read the HTML and posting updates as HTTP. The plugin needs to
know your username and password for the 1984Hosting website.

```sh
export One984HOSTING_Username="<your_username>"
export One984HOSTING_Password="<your_password>"
```

You need only provide this the first time you run the `acme.sh` client with 1984Hosting
validation and then again whenever you change your password at the 1984Hosting site.
The `acme.sh` 1984Hosting plugin does not store your username or password,
but rather saves an authentication token returned by 1984Hosting
in `~/.acme.sh/account.conf` and reuses it when needed.

Ok, let's issue a cert now:

```sh
./acme.sh --issue --dns dns_1984hosting -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2851)


<a name="dns_aruba"/>

## 105. Use Aruba domain API

Get your API token following instruction here at https://admin.arubabusiness.it/DashBoard/WebApiGuide.aspx
```sh
export ARUBA_TK="<API Token>"
export ARUBA_AK="<Username>" 
export ARUBA_AS="<Password>" 
```
Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_aruba -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2994)


<a name="dns_transip"/>

## 106. Use TransIP domain API:

First you need to login to your TransIP account to get your [private key](https://www.transip.nl/cp/account/api/).
```sh
export TRANSIP_Username="MyUserName"
export TRANSIP_Key_File="private_key"
```
Note: TransIP is rather slow, so adding a `--dnssleep` of 300 might be advised.
Note 2: if the DNS fails with something like
```
Please refer to https://curl.haxx.se/libcurl/c/libcurl-errors.html for error code: 60
== Info: SSL certificate problem: unable to get local issuer certificate
```
Then maybe the root CA of TransIP is NOT in your cacerts.
You can check this manually with
```sh
curl -vvI https://api.transip.nl
```
Currently, the root CA of TransIP is COMODO_RSA_Certification_Authority.crt
you can add this trusted root CA with
```
--ca-bundle COMODO_RSA_Certification_Authority.crt
```

This script will create a new access token with a default lifetime of 30 minutes.
Note that these tokens are by default IP-whitelisted and will not work if your IP is not whitelisted in the Transip control panel.
If you cannot work with IP whitelisting, then make sure you create a key with `Only allow whitelisted IP's` unchecked and set the environment variable as follows:
```sh
export TRANSIP_Token_Global_Key="true"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_transip --dnssleep 300 -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2949)

<a name="dns_df"/>

## 107. Use dyndnsfree.de API

```sh
export DF_user="XXX"
export DF_password="XXX"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_df -d example.com -d *.example.com
```

The `df_user` and `df_password` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2897)

<a name="dns_njalla"/>

## 108. Use Njalla API

```sh
export NJALLA_Token="<token>"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_njalla -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2913)


<a name="dns_vercel"/>

## 109. Use Vercel API

Obtain an account token from https://vercel.com/account/tokens.

```sh
export VERCEL_TOKEN="<token>"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_vercel -d example.com -d *.example.com
```


<a name="dns_hetzner"/>

## 110. Use Hetzner DNS API

First you need to create/obtain API tokens on your [Hetzner DNS console](https://dns.hetzner.com/settings/api-token).

```sh
export HETZNER_Token="<token>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_hetzner -d example.com -d *.example.com
```

The `HETZNER_Token` settings will be saved in `[acme.sh-config-home-path]/account.conf`
and will be reused when needed.
The domain(s) zone_id(s) will be saved in `CERT_HOME/[domain]/[domain].conf`
in order to avoid multiple `get_zone_id` requests two months later.

> If you're not already using the new "gases" name servers (hydrogen, oxygen and helium)
> don't forget to change the domain's whois ns section to them and wait about 24-48 Hours.
> See [Hetzner wiki](https://docs.hetzner.com/dns-console/dns/general/what-has-changed).

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2943)


<a name="dns_kappernet"/>

## 111. Use kapper.net DNS API
Contact kapper.net support via support@kapper.net to get your kapper.net DNS Panel API Key and Secret.

For initialization call following in commandline
```sh
export KAPPERNETDNS_Key="yourKAPPERNETapikey"
export KAPPERNETDNS_Secret="yourKAPPERNETapisecret"
```

You can start the acme.sh with following parameters for testing

```sh
./acme.sh --issue --dns dns_kappernet -d example.com -d *.example.com 
```

Please replace `example.com` with the name of the domain you wish to create a certificate for.

After the test you can replace your `kapper.net` DNS Panel API Key and Secret, it is stored in `~/.acme.sh/account.conf`.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2977)


<a name="dns_wedos"/>

## 112. -------

---------

<a name="dns_shellrent"/>

## 113. Use Shellrent API

Shellrent API offers one method to automatically issue certs.

First you need to login to your Shellrent account to get your API key.
In order to use the token, you need to authorize your IP to have access to it.
More Info on https://api.shellrent.com and https://guide.shellrent.com
```sh
export SH_Username="usrXXXX"
export SH_Token="<token>"
```

Alternatively, if the certificate only covers a single zone, you can speed up the process by specify the SH_Domain_ID directly:

```sh
export SH_Username="usrXXXX"
export SH_Token="<token>"
export SH_Domain_ID="xxxxxxxxxxxxx"
```
Let's issue a cert now:

```sh
./acme.sh --issue --dns dns_shellrent -d example.com -d *.example.com
```
The SH_Username and SH_Token and SH_Domain_ID will be saved in ~/.acme.sh/account.conf and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2997)


<a name="dns_openstack"/>

## 114. Use OpenStack domain API

This provider supports [OpenStack Designate](https://docs.openstack.org/designate)
for creating DNS records.

This provider requires the OpenStack Client (python-openstackclient) and
Designate client (python-designateclient) be installed and available in your path.

It also requires you use Keystone V3 credentials, which can be either password or
application credentials provided as environment variables.
Any other authentication method will not save your credentials for renewal.

You will most likely want to source your OpenStack RC file to set your environment variables:

```
. openrc.sh
```
or manually like:
```sh
export OS_AUTH_URL="https://keystone.example.com:5000/"
export OS_USERNAME="<username>"
export OS_PASSWORD="<password>"
export OS_PROJECT_NAME="<project name>"
export OS_PROJECT_DOMAIN_NAME="Default"
export OS_USER_DOMAIN_NAME="Default"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_openstack -d example.com -d *.example.com
```

Your OpenStack credentials will be saved to `~/.acme.sh/account.conf` and reused on renewal.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3054)


<a name="dns_netlify"/>

## 115. Use Netlify API

Generate a Personal Access Token at https://app.netlify.com/user/applications

Set your token for use with:
```sh
export NETLIFY_ACCESS_TOKEN='<token>'
```

Issue a cert with:
```sh
./acme.sh --issue --dns dns_netlify -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3088)


<a name="dns_edgedns"/>

## 116. Use Akamai Edge DNS API

This provider supports the [Akamai Edge DNS](https://developer.akamai.com/api/cloud_security/edge_dns_zone_management/v2.html) API for creating DNS records.

This provider requires Akamai Open Edgegrid Credentials with EdgeDNS API access authorization.
To create and establish your Akamai OPEN CREDENTIALS, see the [authorization](https://developer.akamai.com/legacy/introduction/Prov_Creds.html) and [credentials](https://developer.akamai.com/legacy/introduction/Conf_Client.html) sections of the Akamai Developer Get Started guide.

The Akamai Open Edgegrid credentials must be specified as environment variables as follows:
```sh
export AKAMAI_CLIENT_TOKEN="<akamai edgegrid client token>"
export AKAMAI_ACCESS_TOKEN="<akamai edgegrid access token>"
export AKAMAI_CLIENT_SECRET="<akamai edgegrid client secret>"
export AKAMAI_HOST="<akamai edgegrid api host>"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_edgedns -d example.com -d *.example.com
```

Your Akamai Edgegrid credentials will be saved to `~/.acme.sh/account.conf` and reused on renewal.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3157)


<a name="dns_wedos"/>

## 117. Use WEDOS DNS API
WEDOS DNS provider from the Czech Republic.
DNS API implementation for WEDOS require your WEDOS's account to allow WAPI interface.
You have to login to WEDOS administration, in setting allow WAPI interface (in days when this manual were written it was for free completely).
Configure WAPI interface to XML interface and register the IP addresses (IPv4 and IPv6) of the server where you plan to use acme.sh.
That is from the manual side.

By doing this setting you should have WEDOS web account username and configured WAPI password.
This must be configured to your acme.sh account in the first execution of acme.sh script.
To save it to `~/.acme.sh/account.conf` (and for subsequent acme.sh executions) just execute following before first execution of acme.sh script.
```sh
export WEDOS_Username="<your user name to login to wedos web account>"
export WEDOS_Wapipass="<your WAPI passwords you setup using wedos web pages>"
```

Then you can issue a certificates:
```sh
./acme.sh --issue --dns dns_wedos -d example.com -d *.examle.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3166).

But before reporting run the acme.sh with `--debug 2` switch and append full acme.sh output to the issue report.


<a name="dns_websupport"/>

## 118. Use Websupport DNS API
Obtain an api key and secret from https://admin.websupport.sk/en/auth/apiKey or https://admin.websupport.se/en/auth/security-settings
```sh
export WS_ApiKey="<key>"
export WS_ApiSecret="<secret>"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_websupport -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3486)


<a name="dns_infomaniak"/>

## 119. Use infomaniak.com API

Infomaniak hosts a large number of domains and other hosted services.
Create a token with Domain scope in the API dashboard at
https://manager.infomaniak.com/v3/<account_id>/api/dashboard
and export it as an environment variable:

```sh
export INFOMANIAK_API_TOKEN="<token>"
./acme.sh --issue --dns dns_infomaniak -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3188)


<a name="dns_bookmyname"/>

## 120. Use bookmyname.com API

Bookmyname hosts domains and has a small API.

Export your login/pass as an environment variable:

```sh
export BOOKMYNAME_USERNAME="xxx"
export BOOKMYNAME_PASSWORD="yyy"
./acme.sh --issue --dns dns_bookmyname -d example.com -d *.example.com --dnssleep 600
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3209)


<a name="dns_anx"/>

## 121. Use anexia.com CloudDNS API

For DNS records managed via https://engine.anexia-it.com/clouddns

Export your token as an environment variable:

```sh
export ANX_Token='<token>'
./acme.sh --issue --dns dns_anx -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3238)


<a name="dns_synology_dsm"/>

## 122. Use Synology DSM Synology DNS Server API
Note that in order the script to be working properly acme.sh should be installed on Synology itself.

To issue a cert:
```sh
./acme.sh --issue --dns dns_synology_dsm -d example.com -d *.example.com
```
You can find more details [here](https://github.com/arabezar/acme.sh/wiki)

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3248)


<a name="dns_huaweicloud"/>

## 123. Use HuaweiCloud API
Export your credentials as an environment variable:

About `DomainName` parameters see: https://support.huaweicloud.com/api-iam/iam_01_0006.html

```sh
export HUAWEICLOUD_Username="<Your IAM Username>"
export HUAWEICLOUD_Password="<Your Password>"
export HUAWEICLOUD_DomainName="<Your DomainName>"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_huaweicloud -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3265)


<a name="dns_simply"/>

## 124. Use Simply.com API
Export your credentials, you will find your API key by logging in to your Simply.com account [here](https://www.simply.com/controlpanel/account/):

```sh
export SIMPLY_AccountName="<Your accountname>"
export SIMPLY_ApiKey="<Your API-key>"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_simply -d example.com -d *.example.com
```


<a name="dns_world4you"/>

## 125. Use World4You API
Export your credentials as an environment variable:

```sh
export WORLD4YOU_USERNAME="<customer-id>"
export WORLD4YOU_PASSWORD="<password>"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_world4you -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3269)


<a name="dns_scaleway"/>

## 126. Use Scaleway API

First, you'll need to retrieve your [Api Key](https://www.scaleway.com/en/docs/generate-api-keys/)

```sh
export SCALEWAY_API_TOKEN='xxx'
```

To issue a cert run:

```sh
./acme.sh --issue --dns dns_scaleway -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3295)


<a name="dns_ls"/>

## 127. LS

_removed_


<a name="dns_rackcorp"/>

## 128. Use RackCorp API
Export your credentials as an environment variable:
```sh
export RACKCORP_APIUUID="UUIDHERE"
export RACKCORP_APISECRET="SECRETHERE"
```
To issue a cert:
```sh
./acme.sh --issue --dns dns_rackcorp -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3351)


<a name="dns_ionos"/>

## 129. Using the IONOS domain API

Read [Getting Started](https://developer.hosting.ionos.de/docs/getstarted) to learn how to create an API key.
Export your credentials as environment variables:

```sh
export IONOS_PREFIX="..."
export IONOS_SECRET="..."
```

To issue a certificate, execute:
```sh
./acme.sh --issue --dns dns_ionos -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3379)


<a name="dns_porkbun"/>

## 130. Using the Porkbun API

You must first log in to your Porkbun domain management dashboard and enable API access under details for your domain. Read [Getting Started](https://porkbun.com/api/json/v3/documentation) to learn how to create an API key.
Export your credentials as environment variables:

```sh
export PORKBUN_API_KEY="..."
export PORKBUN_SECRET_API_KEY="..."
```

To issue a certificate, execute:
```sh
./acme.sh --issue --dns dns_porkbun -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3450)


<a name="dns_aurora"/>

## 131. Using the Aurora API

[PCextreme B.V.](https://www.pcextreme.nl/) is a Dutch cloud provider offering cloud services under the family name Aurora.
Head over to [DNS & Health Checks > Users](https://cp.pcextreme.nl/auroradns/users) to get your API credentials.
Export your credentials as environment variables:

```sh
export AURORA_Key="..."
export AURORA_Secret="..."
```

To issue a certificate, execute:
```sh
./acme.sh --issue --dns dns_aurora -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3459)


<a name="dns_azion"/>

## 132. Using the Azion DNS API

https://www.Azion.com/ is a Edge Computing Platform to build modern applications at edge.
This API reflects the [Intelligent DNS](https://www.azion.com/en/documentation/products/intelligent-dns/) product.
Read this [documentation](https://www.azion.com/en/documentation/products/api/v3/) to create a username/password and permissions to use this plugin.

Export your username/password as environment variables:
```sh
export AZION_Email="user@example.com"
export AZION_Password="password"
```

To issue a certificate, execute:
```sh
./acme.sh --issue --dns dns_azion -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3555)


<a name="dns_oci"/>

## 133. Using Oracle Cloud Infrastructure DNS

See: https://github.com/acmesh-official/acme.sh/wiki/How-to-use-Oracle-Cloud-Infrastructure-DNS

<a name="dns_hostline"/>

## 134. Utilisation de l'API DNS Hostline Hébergement VPS

Créer un token API sur votre compte [Hostline Hébergement VPS](https://www.hostline.fr).

Ajouter les variables API suivantes :
```sh
export HOSTLINE_Token="xxx" # (obligatoire)
export HOSTLINE_Url="https://api.hostline.fr" # (optionnel)
export HOSTLINE_Ttl="60" # ttl custom record (optionnel)
```

Pour générer un certificat exécuter la commande correspondante à votre cas :
```sh
./acme.sh --issue --dns dns_hostline -d example.com -d *.example.com
```

Les variables `HOSTLINE_Token`, `HOSTLINE_Url` (optionnel) et `HOSTLINE_Ttl` (optionnel) doivent être définies dans le fichier `/root/.acme.sh/account.conf`.

Si vous rencontrez un problème sur l'API Hostline Hébergement VPS, merci de rapporter votre problème sur le lien suivant:
https://github.com/acmesh-official/acme.sh/issues/3675



<a name="dns_veesp"/>

## 135. Use Veesp domain API

[Veesp](https://veesp.com/) offers HTTP REST [API](https://secure.veesp.com/userapi#dns-82) to manage vital details of account and services like DNS. Your standard login credentials is needed:

```sh
export VEESP_User="username@domain.com"
export VEESP_Password="password"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_veesp -d example.com -d *.example.com
```

The `VEESP_User` and `VEESP_Password` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3712)


<a name="dns_cpanel"/>

## 136. Use cPanel DNS systems

First you need to log into the cPanel interface and generate an API key for your account (under Security -> Manage API Tokens).
Then set your username, api token and hostname:

```sh
export cPanel_Username="username"
export cPanel_Apitoken="apitoken"
export cPanel_Hostname="https://hostname:port"
```
example

```sh
export cPanel_Username="myadminuseratnordicway"
export cPanel_Apitoken="CXJ8HRXFNS363RQ71Z51TKM9KTHRFZVE"
export cPanel_Hostname="https://cp04.nordicway.dk:2083"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_cpanel -d example.com -d *.example.com
```

See https://api.docs.cpanel.net/cpanel/introduction/#cpanel-or-webmail-session-url-1 regarding cPanel ports.

The `cPanel_Username`, `cPanel_Apitoken` and `cPanel_Hostname` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3732)


<a name="dns_ispman"/>

## 137. Use ISPMan domain API

!!! IMPORTANT: Make sure the version of ISPMan supports TXT records !!!

The `dns_ispman.sh` api Adds & Deletes domain TXT records by authenticating into the [ISPMan](http://ispman.sourceforge.net/) Customer Control Panel and executing related HTTP POST & GET requests.

The `dns_ispman.sh` api requires your `<domain>` and `<passwd>` for authentication:
```sh
export ISPMan_Username="<domain>"
export ISPMan_Password="<passwd>"
```

The `ISPMan_Username` and `ISPMan_Password` will be saved in `$LE_WORKING_DIR/account.conf` and will be reused for certificate renewals.

Ok, let's issue a cert:

```sh
./acme.sh --issue --dns dns_ispman -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3751)


<a name="dns_dnshome"/>

## 138. Use dnsHome.de DNS API

```sh
export DNSHOME_Subdomain=""
export DNSHOME_SubdomainPassword=""
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_dnshome -d subdomain.ddnsdomain.tld
```

The `DNSHOME_Subdomain` and `DNSHOME_SubdomainPassword` will be saved in the domain conf and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3819)


<a name="dns_mythic_beasts"/>

## 139. Use mythic-beasts.com DNS API

First obtain you API key from the control panel.

```sh
export MB_AK="<Key>"
export MB_AS="<Secret>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_mythic_beasts -d example.com -d *.example.com
```

The credentials will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3848)



<a name="dns_sdns"/>

## 140. Use s-dns.de API

First generate your dns zone key.
Open your existing nameserver entry, click on [Passwort für dynamic DNS generieren] and save your zone.
This generates a new key for your zone.

```sh
export SDNS_ZONE_KEY="<Key>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_sdns -d example.com -d *.example.com
```

S-dns nameservers use anycast.
It is therefore possible that the server next to your location already provides the new record,
while the CA reaches another one that does not have the TXT record yet.
To avoid such timing errors the `--dnssleep` flag can be set to a value of 240 seconds.

```sh
./acme.sh --issue --dns dns_sdns -d example.com -d *.example.com --dnssleep 240
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3917)


<a name="dns_udr"/>

## 141. Using the united-domains reselling DNS API

Create an account at [ud reselling](https://www.ud-reselling.com/).

There is no option to use an API key, so you just need to set your credentials as environment variables:

```sh
export UDR_USER="..."
export UDR_PASS="..."
```

To issue a certificate, execute:

```sh
./acme.sh --issue --dns dns_udr -d example.com -d *.example.com
```

The `UDR_USER` and `UDR_PASS` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3923)


<a name="dns_curanet"/>

## 142. Using the curanet DNS API

Login to your curanet account, create a new API Application, and use client_id and secret as shown below

```sh
export CURANET_AUTHCLIENTID="..."
export CURANET_AUTHSECRET="..."
```

To issue a certificate, execute:

```sh
./acme.sh --issue --dns dns_curanet -d example.com -d *.example.com
```

The `CURANET_AUTHCLIENTID` and `CURANET_AUTHSECRET` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3933)


<a name="dns_artfiles"/>

## 143. Use ArtFiles.de DNS API

First, verify that API access is already enabled:
1. Go to ArtFiles.de's **DCP** (Domain Control Panel).
2. Click **Passwords** in the left menu.
3. To the menu's right, the drop-down menu for **Active** is either `active` or `inactive`.
4. If **Active** is already set to `active`, skip this step. Otherwise, enter your desired password into both text boxes, save it somewhere else (e. g. Firefox, KeePass, etc.) & click **Apply** below.
5. Copy **Username**'s value, i.e. the one that starts with `api` & then continues with your account number which is something like `a12345678`.

Export `AF_API_USERNAME` & `AF_API_PASSWORD` only once (saved into domain's config file upon 1st successful script run):
```sh
export AF_API_USERNAME="api12345678"
export AF_API_PASSWORD="apiPassword"
```

To issue a certificate, execute:
```sh
./acme.sh --issue --dns dns_artfiles -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4718)


<a name="dns_geoscaling"/>

## 144. Use Geoscaling.com DNS2

Create an account at [Geoscaling](https://www.geoscaling.com/).

Set your credentials as environment variables:

```sh
export GEOSCALING_Username="..."
export GEOSCALING_Password="..."
```

To issue a certificate, execute:

```sh
./acme.sh --issue --dns dns_geoscaling -d example.com -d *.example.com
```

The `GEOSCALING_Username` and `GEOSCALING_Password` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3969)


<a name="dns_fornex"/>

## 145. Use fornex.com API

Get an API key in your fornex.com account page. Then

```sh
export FORNEX_API_KEY="<Key>"
```

To issue a cert, run command:

```sh
./acme.sh --issue --dns dns_fornex -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/3998)


<a name="dns_dnsservices"/>

## 146. Use DNS.Services API

Use your credentials
```sh
export DnsServices_Username="user@example.com"
export DnsServices_Password="<YourPassword>"
```

To issue a cert, run command:
```sh
./acme.sh --issue --dns dns_dnsservices -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4152)


<a name="dns_nodion"/>

## 147. Use Nodion DNS API

You are able to create a free account on https://app.nodion.com and add an API key used by acme.sh by visiting the [settings page](https://app.nodion.com/user/security).
Please take this token and set it as env variable.

```sh
export NODION_API_KEY="<Token>"
```

To issue a certificate, execute:

```sh
acme.sh --issue --dns dns_nodion -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4157)


<a name="dns_la"/>

## 148. Use dns.la API

Use your credentials
```sh
export LA_Id="<appid>"
export LA_Key="<apikey>"
```

To issue a cert, run command:

```sh
./acme.sh --issue --dns dns_la -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4257)


<a name="dns_yc"/>

## 149. Use Yandex Cloud DNS API

Create a new service account with role `dns.editor` and [create authorized key](https://cloud.yandex.com/en-ru/docs/iam/operations/authorized-key/create) for him.

Required parameters:
```sh
export YC_Folder_ID="YC Folder ID"
export YC_SA_ID="Service Account ID"
export YC_SA_Key_ID="Service Account IAM Key ID"
# You need use YC_SA_Key_File_PEM_b64 or YC_SA_Key_File_Path
export YC_SA_Key_File_PEM_b64="Base64 content of private.key"
export YC_SA_Key_File_Path="/path/to/private.key"
```

Optional parameters:
```sh
export YC_Zone_ID="DNS Zone ID"
```

Now you can issue a cert:

```sh
./acme.sh --issue --dns dns_yc -d example.com -d *.example.com
```

Both, `YC_Folder_ID`, `YC_SA_ID`, `YC_SA_Key_ID`, `YC_SA_Key_File_PEM_b64` or `YC_SA_Key_File_Path` and `YC_Zone_ID` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4210)


<a name="dns_bunny"/>

## 150. Use Bunny DNS API to automatically issue cert

Find your API key at https://panel.bunny.net/account
Then export the key:

```sh
export BUNNY_API_KEY="your-api-key-goes-here"
```

Then you can issue a cert:
```sh
./acme.sh --issue --dns dns_bunny -d example.com -d *.example.com
```

The `BUNNY_API_KEY` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4296)


<a name="dns_selfhost"/>

## 151. Use Selfhost DNS API

- create a new TXT record for a subdomainname with the needed prefix e.g. "_acme-challenge.example.com" (default) or "alias.example.com" (dns alias mode)
    - for wildcard subdomains add a second TXT record for the identical subdomainname
- edit the TXT record and note the ID in (...) behind the subdomainname
- export each subdomainname (including the prefix) and the corresponding record IDs in SELFHOSTDNS_MAP like "subdomainname:RID1:RID2"
    - at least one RID must be set, up to two are supported for wildcard subdomains
    - each entry must be seperated by a space
- export username and password in SELFHOSTDNS_USERNAME and SELFHOSTDNS_PASSWORD

_Note: For `username` you have to use your account / customer number. You can find them in any invoice or on the right top of the selfhost dashboard._

```sh
export SELFHOSTDNS_USERNAME="myname"
export SELFHOSTDNS_PASSWORD="mypass"
export SELFHOSTDNS_MAP="_acme-challenge.example.com:12345:98765 alias.example.com:11111"

acme.sh --issue --dns dns_selfhost -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4291)


<a name="dns_rage4"/>

## 152. Use rage4 DNS API

Use your credentials

```sh
export RAGE4_TOKEN="example-token"
export RAGE4_USERNAME="example@user.local"
```

To issue a cert, run command:

```sh
./acme.sh --issue --dns dns_rage4 -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4306)


<a name="dns_gcore"/>

## 153. Use GCore DNS API

Login to your [GCore](https://accounts.gcore.com/profile/api-tokens) account and create an API Key.

```sh
export GCORE_Key='<your_gcore_api_key>'
```

To issue a cert, run command:

```sh
./acme.sh --issue --dns dns_gcore -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4460)


<a name="dns_dynadot"/>

## 154. Use dynadot DNS API
PENDING Pull Request: https://github.com/acmesh-official/acme.sh/pull/4510

**Please read the comments in `dnsapi/dns_dynadot.sh` to understand the issues and limitations with dynadot's api before reporting any bugs and for more information on the options below**
Login to to your dynadot account and create an api token
```sh
DYNADOTAPI_Token="your_api_token"
```
Optional settings:
```sh
DYNADOT_ADD_DNS_SLEEP=1800
DYNADOT_REMOVE_DNS_SLEEP=1800
DYNADOTAPI_SKIP_REMOVE=SKIP
DYNADOTAPI_API_RETRIES=5
DYNADOTAPI_RETRY_SLEEP=30
```
* The `--dnssleep` command line argument specifies the amount of sleep before requesting validation of records.  When adding two text records, that sleep only occurs after both records have been added.  The sleep settings above affect each dynadot operation.
* `DYNADOT_ADD_DNS_SLEEP` is the number of seconds to sleep after adding a TXT record (for wildcard domains this will happen twice before validation).  Recommended to set this at 1800 or higher if adding multiple records is required for your request or when making back to back requests.
* `DYNADOTAPI_SKIP_REMOVE=SKIP` will skip removing TXT records.  This is useful to save wait time when making multiple calls, however, TXT records will need to be manually removed after the process completes.
* `DYNADOT_REMOVE_DNS_SLEEP` is the number of seconds to sleep after removing a TXT record.  Recommended to set this at 1800 or higher if adding multiple records is required for your request or when making back to back requests.  This is not required when using `DYNADOTAPI_SKIP_REMOVE=SKIP`
* `DYNADOTAPI_API_RETRIES` number of times to attempt a DYNADOT api call.
* `DYNADOTAPI_RETRY_SLEEP` sleep time between DYNADOT api calls (only applied if a call fails and DYNADOTAPI_API_RETRIES is set great than 1)

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4523)


<a name="dns_ipv64"/>

## 155. Use IPv64 DNS API

Login to your [IPV64](https://ipv64.net/account.php?login) Account and copy your API Key.

```sh
export IPv64_Token="your_ipv64_api_key"
```

To issue a cert, run command:

```sh
./acme.sh --issue --dns dns_ipv64 -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4419)


<a name="dns_nanelo"/>

## 156. Use Nanelo DNS API

Login to your https://nanelo.com Account, navigate to Settings > API Keys and generate a new API Key.
Copy it and set it like the following:

```sh
export NANELO_TOKEN="<your_nanelo_api_key>"
```

To issue a cert, run the following command:

```sh
./acme.sh --issue --dns dns_nanelo -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4519)


<a name="dns_googledomains"/>

## 157. Use Google Domains DNS API

Visit https://domains.google.com/registrar/ and click "Manage" on the domain.
Then, in the Security settings, generate an access token for the ACME DNS API.
Save this access token as it is only displayed once.

```sh
export GOOGLEDOMAINS_ACCESS_TOKEN="<generated-access-token>"
```

To issue a cert, run the following:
```sh
./acme.sh --issue --dns dns_googledomains -d example.com -d *.example.com
```

The script tries to infer the zone registered with Google Domains by matching the domain against the Google Domains API. To manually specify the zone, do the following prior to running the issuing command:

```sh
export GOOGLEDOMAINS_ZONE="google-domains-zone"
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4545)


<a name="dns_dnsexit"/>

## 158. Use DNSExit API to automatically issue cert

You'll need an API key for your DNSExit account which you can find under your Account Profile.
You will also need your account login (username and password).

```sh
export DNSEXIT_API_KEY="<Your API key>"
export DNSEXIT_AUTH_USER="<Your username>"
export DNSEXIT_AUTH_PASS="<Your password>"
```

To issue a cert, run the following:
```sh
./acme.sh --issue --dns dns_dnsexit -d example.com -d *.example.com
```

The login variables will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4719).

<a name="dns_limacity"/>

## 159. Use Lima-City API to automatically issue cert

You'll need an API key for your Lima-City account which you can find under Account Section in your User control panel. The API key must have following roles: dns.admin, domains.reader

```sh
export LIMACITY_APIKEY="<Your API key>"
```

To issue a cert, run the following:
```sh
./acme.sh --issue --dns dns_limacity -d example.com -d *.example.com
```

The login variables will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4758).

<a name="dns_tencent"/>

## 160. Use TencentCloud (DNSPod) API

Please visit https://console.cloud.tencent.com/cam/capi to obtain the API key.

```sh
export Tencent_SecretId="<Your SecretId>"
export Tencent_SecretKey="<Your SecretKey>"
```

To issue a cert, run the following:
```sh
./acme.sh --issue --dns dns_tencent -d example.com -d *.example.com
```

The login variables will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Docs:
* https://cloud.tencent.com/document/product/302/105900

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4781)



<a name="dns_samba"/>

## 161. Use Samba AD DC

This API requires you to have `samba-tool` available, you don't need the full samba installation on a remote machine (if the machine you use to generate the certificate isn't the same as the Samba AD DC). On Debian, you can get it with the `samba-common-bin` package.

Then you need to provide the host, username and password of an administrator to change the DNS settings:

```sh
export SAMBA_HOST=dc1.example.com
export SAMBA_USER=Administrator
export SAMBA_PASS=MyAdminP@ssword
```

Then you can issue your certificates with:

```sh
./acme.sh --issue --dns dns_samba -d example.com -d *.example.com
```

Or even in 1 line:

```sh
SAMBA_HOST=dc1.example.com SAMBA_USER=Administrator SAMBA_PASS=MyAdminP@ssword ./acme.sh --issue --dns dns_samba -d example.com -d *.example.com
```

The `SAMBA_HOST`, `SAMBA_USER` and `SAMBA_PASS` settings will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4852)

<a name="dns_west_cn"/>

## 162. Use West.cn API

Please visit https://www.west.cn/manager/API/APIconfig.asp to obtain the Plaint API key.   
`<Your Encryption APIKey> = md5(<Your Plaint APIKey>)`
```sh
export WEST_Username="<Your Username>"
export WEST_Key="<Your Encryption APIKey>"
```

To issue a cert, run the following:
```sh
./acme.sh --issue --dns dns_west_cn -d example.com -d *.example.com
```

The login variables will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4894)

<a name="dns_hosttech"/>

## 163. Use Hosttech API

Create an DNS API token in hosttech portal (DNS editor).

Set your API key:
```sh
export Hosttech_Key='xxx'
```

To issue a certificate run:
```sh
./acme.sh --issue --dns dns_hosttech -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/4900)

<a name="dns_alviy"/>

## 164. Use Alviy.com domain API to automatically issue cert

First you need to register to your account to get your API Key and Secret.

https://cloud.alviy.com/profile/

API token is creating automatically.

```sh
export Alviy_token="<token>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_alviy -d example.com -d *.example.com
```

The `Alviy_token` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/5115)

<a name="dns_timeweb"/>

## 165. Use Timeweb Cloud DNS API

To begin, acquire a Timeweb Cloud API JWT token. You can obtain one via the [Timeweb Cloud control panel](https://timeweb.cloud/my/api-keys).

Next, provide the JWT token to the script using one of two methods:
* As the "TW_Token" variable. For example:
```sh
export TW_Token='eyJhbG...zUxMiIs'
```
* As a "TW_Token" entry in acme.sh account configuration file (located at ~/.acme.sh/account.conf by default). For example, `TW_Token='eyJhbG...zUxMiIs'`

Finally, сonsider the following command as an example of how to issue a certificate using the ACME DNS-01 challenge:
```sh
./acme.sh --issue --dns dns_timeweb -d example.com,*.example.com,foo.bar.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/5140).

<a name="dns_myloc"/>

## 166. Use myLoc.de / webtropia.com DNS API

First, you need a domain hosted at myLoc.de or webtropia.com. A Webtropia also allows to use the myloc.de API.
You need to register a token via the [myLoc.de website](https://zkm.myloc.de/s/api/token) or the [Webtropia.com website](https://zkm.webtropia.com/s/api/token).

As the API does not allow to match domain names to zones yet, the zone has to be set manually if you plan to use subdomains.
You can set the zone as well as the token using environment variables:
```sh
export MYLOC_token=aabbccddeeffgghhiijjkkllmmnnjjkkllmmnnooppqqrrsstt
export MYLOC_zone=example.com
```
If `MYLOC_zone` is not set, it will be guessed by stripping the `_acme-challenge.` prefix from the domains being processed.
This may not match the zone, for example for issueing certificates for `sub1.example.com`, the zone probably is `example.com`.

Now, use the dns_myloc backend to issue and renew certificates using DNS-01:
```sh
./acme.sh --issue --dns dns_myloc -d example.com,*.example.com,foo.bar.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/5193).

<a name="dns_yandex360"/>

## 167. Use Yandex 360 for Business DNS API

### a. Set up OAuth application:

1. Log in as an organization administrator on Yandex.
2. [Create an OAuth application at Yandex ID](https://oauth.yandex.ru/client/new).
3. Choose "Web services" platform.
4. Set Redirect URI to `https://oauth.yandex.ru/verification_code`.
5. Select the following permissions:
    - "Manage DNS records" (directory:manage_dns)
    - "Read organization data" (directory:read_organization) (optional if the user exports the YANDEX360_ORG_ID variable manually)
    - "Read organization domain data" (directory:read_domains)
6. Save the Client ID and Client Secret.

### b. Obtain Yandex 360 Organization ID:

*This step is optional as the Organization ID can be obtained automatically. However, the user can specify it manually as described below.*

1. After setting up the OAuth application, [visit Yandex 360 for Business Administration](https://admin.yandex.ru/).
2. In the upper-left corner of the page, select the correct organization from the list if you have multiple organizations.
3. In the lower-left corner of the page, find and note the Organization ID.

### c. Set up environment variables:

Depending on whether you are using OAuth or a manually obtained access token, export the appropriate variables:

#### i. Using OAuth (recommended):

Export the following variables:

```
export YANDEX360_CLIENT_ID="your_client_id"
export YANDEX360_CLIENT_SECRET="your_client_secret"
export YANDEX360_ORG_ID="your_organization_id"  # optional if directory:read_organization permission is granted
```

#### ii. Manually obtained access token:

1. Obtain an access token manually:
    - Go to: `https://oauth.yandex.ru/authorize?response_type=token&client_id=<your_application_id>`
    - Replace `<your_application_id>` with your OAuth application's Client ID.
    - Authorize and obtain the token.

2. Export the following variables:

```
export YANDEX360_ACCESS_TOKEN="your_access_token"
export YANDEX360_ORG_ID="your_organization_id"  # optional if directory:read_organization permission is granted
```

### d. Issue/renew certificate:

Use the `acme.sh` command with the `--dns dns_yandex360` parameter. For example:

```
./acme.sh --issue --dns dns_yandex360 --dnssleep 600 -d example.com -d *.example.com
```

When using OAuth you will need to complete a one-time authorization procedure:
1. On first run, the script will initiate the device authorization process.
2. You'll be prompted to visit a URL and enter a code for authorization.
3. After successful authorization, the access token will be obtained automatically.

### Important notes:

- The script automatically refreshes the access token when needed. You don't need to manually update the token for subsequent operations **if using OAuth**.
- If you are using the manual token method, you will need to update `YANDEX360_ACCESS_TOKEN` manually due to the limited token lifespan.
- Ensure you include the `--dnssleep` option with a value of at least 600 seconds (10 minutes) to account for the slow DNS record propagation on Yandex 360 DNS.
- Whenever possible, use the OAuth method as it provides automatic token refresh and a higher level of security.
- Yandex 360 Organization ID can be obtained automatically if the "Read organization data" (directory:read_organization) permission is granted. If not, you must export `YANDEX360_ORG_ID` variable manually.
- [You can learn more about the Yandex 360 for Business DNS API access procedure here.](https://yandex.ru/dev/api360/doc/concepts/access.html)
- [You can learn more about the OAuth device authorization flow here.](https://yandex.ru/dev/id/doc/ru/codes/screen-code-oauth)
- [You can learn more about obtaining debug tokens here.](https://yandex.ru/dev/id/doc/ru/tokens/debug-token)
- [Report any bugs or issues here.](https://github.com/acmesh-official/acme.sh/issues/5213)

<a name="dns_he_ddns"/>

## 168. Use HE DDNS DNS API

This uses the Dynamic DNS API in the Hurricane Electric DNS service (https://dns.he.net/).

1. Add new TXT record for `_acme-challenge.example.com` in HE DNS interface, select "Enable entry for dynamic dns"
(the content will automatically be like "Acme challenge key", that's fine)
2. Click the "Generate a DDNS key" button in the DDNS column, click the "Generate a key" button in the form,
copy the key and Submit the form
3. Set the HE_DDNS_KEY variable:
```
export HE_DDNS_KEY="the_generated_key"
```

To issue a certificate run:
```sh
./acme.sh --issue --dns dns_he_ddns -d example.com
```

The `HE_DDNS_KEY` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/5238)

<a name="dns_ionos_cloud"/>

## 169. Using the IONOS Cloud DNS API

For information on how to obtain a token, please read the IONOS Cloud API [documentation](https://docs.ionos.com/reference/readme/get-started#authorization).

Please note that [IONOS Cloud DNS](https://docs.ionos.com/cloud/network-services/cloud-dns) API is different from [IONOS Core API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#129-using-the-ionos-domain-api)

After obtaining token, you need to export it as an environment variable:

```
export IONOS_TOKEN="..."
```

Then, you can issue a certificate by executing:

```
./acme.sh --issue --dns dns_ionos_cloud -d example.com
```

Please report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/5243)

<a name="dns_omglol"/>

## 170. Using the Omg.lol DNS API

1. Collect your API Key
- Navigate to [https://home.omg.lol/account](https://home.omg.lol/account)
- Log in (if not already logged in)
- Scroll all the way to the bottom
- click the clipboard to copy your API key

2. Export the following variables:
```sh
export OMG_ApiKey="your_api_key" # as collected from your accounts page
export OMG_Address="your_omg.lol_address" # Leading '@' not required
```

3. Use the `acme.sh` command with the `--dns dns_omglol` parameter to issue your certificate. For example:

```sh
./acme.sh --issue --dns dns_omglol --dnssleep 120 -d address.omg.lol -d *.address.omg.lol
```

Please report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/5299)

<a name="dns_pmiab"/>

## 171. Use Power-Mailinabox

Use the Power-Mail-In-a-Box (PMIAB) Custom DNS REST API interface to PMIAB DNS.
You only need to set your PMIAB login credentials and the fully qualified domain name of the PMIAB Server.
Suggest single quote over double quote to ensure characters are not interpreted by the shell - important for passwords.

```sh
export PMIAB_Username='your_PMIAB_admin_username'
export PMIAB_Password='your_PMIAB_admin_password'
export PMIAB_Server='FQDN_of_your_PMIAB_Server'
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_pmiab -d example.com -d *.example.com
```

The `PMIAB_Username`, `PMIAB_Password` and `PMIAB_Server` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Please report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2550)

<a name="dns_technitium"/>

## 172. Use Technitium DNS Server API

If your Domain is hosted on your (own) Technitium DNS Server, 
then 
```sh
export Technitium_Server=url.of.your.name.server # like ns1.example.com
export Technitium_Token=API_TOKEN
``` 
Then issue a cert:
```sh
./acme.sh --issue --dns dns_technitium -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/6116)

<a name="dns_zoneedit"/>

## 173. Use ZoneEdit DNS API

This uses ZoneEdit DNS API for [zoneedit](https://www.zoneedit.com/) dns service. It was developed as a separate project [sslcertzoneedit](https://github.com/blueslow/sslcertzoneedit) with information provided in the [Zoneedit forum](https://forum.zoneedit.com/index.php?threads/automating-changes-of-txt-records-in-dns.7394/post-19772)

Before first execution define the following in sh (or bash):
```sh
export ZONEEDIT_ID="your id"
export ZONEEDIT_Token="Your token"
``` 
Where ZONEEDIT_ID is your zone edit ID and ZONEEDIT_Token is the same token as for dynamic IP dns update at [zoneedit](https://www.zoneedit.com/). 

Then issue a cert:
```sh
./acme.sh --issue --dns dns_zoneedit -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/6135)

<a name="dns_anikeen"/>

## 174. Use Anikeen Cloud DNS API

This uses Anikeen DNS API for [Anikeen Cloud](https://anikeen.cloud) dns service.

For information on how to obtain a token, please read the [Anikeen Cloud API documentation](https://docs.api.anikeen.cloud).

After obtaining token, you need to export it as an environment variable:

```sh
export ANIKEEN_API_KEY="your_access_token"
```  

Then, you can issue a certificate by executing:

```sh
./acme.sh --issue --dns dns_anikeen -d example.com -d *.example.com
```

Please report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/6175)

<a name="dns_mijnhost"/>

## 175. Use mijn.host DNS API *(merge request pending)*

This script uses DNS API for [mijn.host](https://mijn.host/) dns service and is based on [API documentation](https://mijn.host/api/doc/)

Before first execution define the following in sh (or bash):
```sh
export MIJNHOST_API_KEY="your API key"
``` 

API keys can be generated in mijn.host customer portal [API settings](https://mijn.host/cp/account/api/). Be aware that the maximum
lifetime for an API key is 6 months, so you'll need to update it regularly. 

To issue a cert:
```sh
./acme.sh --issue --dns dns_mijnhost -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/6177)

<a name="dns_openprovider_rest"/>

## 176. Use OpenProvider (REST) DNS API *(merge request pending)*

This script uses DNS API for [OpenProvider](https://www.openprovider.com) domain and dns service and is based on their newer REST [API documentation](https://docs.openprovider.com/doc/all). Now allowing usage of a single request validation entry for the DNS API script without the need to do a full DNS zone overlay everytime like in the older XML specifications.

Before first execution define the following in sh (or bash):
```sh
export OPENPROVIDER_REST_USERNAME="username"
export OPENPROVIDER_REST_PASSWORD="password"
``` 

The API authentication is based on the [OpenProvider control panel](https://cp.openprovider.eu) credentials;
* username: API/account username, same as OpenProvider control panel username
* password: API/account password, same as OpenProvider control panel username

Both `OPENPROVIDER_REST_USERNAME` and `OPENPROVIDER_REST_PASSWORD` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

If there are multiple control panel contacts (like admin/tech/billing) under a reseller account, decide which account/contact you want to use for API connection/integration and use its username and password. You could create a dedicated account for the DNS API scripting to be executed. For more information please use the OpenProvider article [Getting-started-with-Openprovider-API](https://support.openprovider.eu/hc/en-us/articles/360025683173-Getting-started-with-Openprovider-API)

To issue a cert:
```sh
./acme.sh --issue --dns dns_openprovider_rest -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/6122)

<a name="dns_beget"/>

## 177. Use Beget.com DNS API

This uses [Beget.com](https://beget.com/) DNS API.

1. First you need to login to your beget.com acount and enable the API.
Go to [this page](https://cp.beget.com/settings/access/api) ("Account settings" -> "Access restriction" -> "Beget API") and turn on "Allow API authentication" switch.

2. Set separate API password. Push `Set a new password for the API` button for that.

3. Set "Allowed methods" checkboxes:
    - `DNS admnistration`
    - `Domain administration`
    - or simply use `All API functions` checkbox

Before running acme.sh script you need to provide your login/password:

```sh
export Beget_Username="your account login"
export Beget_Password="API password"
```

To essue your sertificate run:

```sh
./acme.sh --issue --server letsencrypt --dns dns_beget -d example.com
```

For wildcard certificate use:

```sh
./acme.sh --issue --server letsencrypt --dns dns_beget -d example.com -d '*.example.com'
```

*Note: "ZeroSSL" does not work in some countries, so use "Let's Encrypt" instead.*


Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/6200)

<a name="dns_myapi"/>

## Use custom API

If your API is not supported yet, you can write your own DNS API.

Let's assume you want to name it `myapi`:

1. Create a bash script named `~/.acme.sh/dns_myapi.sh`,
2. In the script you must have a function named `dns_myapi_add()` which will be called by acme.sh to add the DNS records.
3. Then you can use your API to issue cert like this:

```sh
./acme.sh --issue --dns dns_myapi -d example.com -d *.example.com
```

For more details, please check our sample script: [dns_myapi.sh](https://github.com/acmesh-official/acme.sh/blob/master/dnsapi/dns_myapi.sh)

See: [DNS API Dev Guide](https://github.com/acmesh-official/acme.sh/wiki/DNS-API-Dev-Guide)

<a name="dns_lexicon"/>

## Use lexicon DNS API

[How to use lexicon DNS API](https://github.com/acmesh-official/acme.sh/wiki/How-to-use-lexicon-DNS-API)

-----------------------------------

**More APIs coming soon...**
